package org.sharengo.wikitty;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WikittyDAO<E extends BusinessEntityWikitty> {
    
    protected static Log log = LogFactory.getLog( WikittyDAO.class );

    private WikittyProxy proxy;
    private Class<E> clazz;
    
    public WikittyDAO() {
        clazz = getActualClassType();
    }
    
    private Class<E> getActualClassType() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class<E> clazz = (Class<E>)type.getActualTypeArguments()[0];
        return clazz;
    }

    public void addLabel(String wikittyId, String label) {
        proxy.addLabel(wikittyId, label);
    }

    public String asyncExportAllByCriteria(Criteria criteria) {
        return proxy.asyncExportAllByCriteria(criteria);
    }

    public String asyncExportAllByExample(E e) {
        return proxy.asyncExportAllByExample(e);
    }

    public String asyncImportFromUri(String uri) {
        return proxy.asyncImportFromUri(uri);
    }

    public void cancelJob(String jobId) {
        proxy.cancelJob(jobId);
    }

    public void delete(Collection<String> ids) {
        proxy.delete(ids);
    }

    public void delete(String id) {
        proxy.delete(id);
    }

    public boolean equals(Object obj) {
        return proxy.equals(obj);
    }

    public Set<String> findAllAppliedLabels(String wikittyId) {
        return proxy.findAllAppliedLabels(wikittyId);
    }

    public PagedResult<E> findAll() {
        return proxy.findAllByCriteria(clazz, null);
    }

    public PagedResult<E> findAllByCriteria(Criteria criteria) {
        return proxy.findAllByCriteria(clazz, criteria);
    }

    public PagedResult<E> findAllByExample(E e, int firstIndex, int endIndex, String... fieldFacet) {
        return proxy.findAllByExample(e, firstIndex, endIndex, fieldFacet);
    }

    public PagedResult<Wikitty> findAllByLabel(String label, int firstIndex, int endIndex) {
        return proxy.findAllByLabel(label, firstIndex, endIndex);
    }

    public E findByCriteria(Criteria criteria) {
        return proxy.findByCriteria(clazz, criteria);
    }

    public E findByExample(E e) {
        return proxy.findByExample(e);
    }

    public Wikitty findByLabel(String label) {
        return proxy.findByLabel(label);
    }

    public void freeJobResource(String jobId) {
        proxy.freeJobResource(jobId);
    }

    public WikittyService getWikittyService() {
        return proxy.getWikittyService();
    }

    public int hashCode() {
        return proxy.hashCode();
    }

    public JobState infoJob(String jobId) {
        return proxy.infoJob(jobId);
    }

    public List<E> restore(List<String> id) {
        return proxy.restore(clazz, id, true);
    }

    public E restore(String id) {
        return proxy.restore(clazz, id, true);
    }

    public <E extends BusinessEntity> E restore(String id,Class<E> clazz ) {
        return proxy.restore(clazz, id);
    }

    public Tree restoreTree(String wikittyId) {
        return proxy.restoreTree(wikittyId);
    }

    public Map.Entry<E, Integer> restoreNode(String wikittyId) {
        return restoreNode(wikittyId, null);
    }

    public Map.Entry<E, Integer> restoreNode(String wikittyId, Criteria filter) {
        Class<E> clazz = getActualClassType();
        return proxy.restoreNode(clazz, wikittyId, filter, true);
    }

    public Map<E, Integer> restoreChildren(String wikittyId) {
        return restoreChildren(wikittyId, null);
    }

    public Map<E, Integer> restoreChildren(String wikittyId, Criteria filter) {
        Class<E> clazz = getActualClassType();
        return proxy.restoreChildren(clazz, wikittyId, filter, true);
    }

    public Wikitty restoreVersion(String wikittyId, String version) {
        return proxy.restoreVersion(wikittyId, version);
    }

    public boolean hasType(String wikittyId) {
        Class<E> clazz = getActualClassType();
        return proxy.hasType(clazz, wikittyId);
    }

    public void setWikittyService(WikittyService wikittyService) {
        proxy.setWikittyService(wikittyService);
    }

    public E store(E e) {
        return proxy.store(e);
    }

    public List<E> store(List<E> objets) {
        return proxy.store(objets);
    }

    public String syncExportAllByCriteria(Criteria criteria) {
        return proxy.syncExportAllByCriteria(criteria);
    }

    public String syncExportAllByExample(E e) {
        return proxy.syncExportAllByExample(e);
    }

    public void syncImportFromUri(String uri) {
        proxy.syncImportFromUri(uri);
    }

    public void syncImportFromXml(String xml) {
        proxy.syncImportFromXml(xml);
    }

    public String toString() {
        return proxy.toString();
    }
    
    public void setProxy(WikittyProxy proxy) {
        this.proxy = proxy;
    }
    
    
}
