/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.thoughtworks.selenium.SeleniumException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

public class CreateCookie
extends SeleneseCommand<Void> {
    private final Pattern NAME_VALUE_PAIR_PATTERN = Pattern.compile("([^\\s=\\[\\]\\(\\),\"\\/\\?@:;]+)=([^\\[\\]\\(\\),\"\\/\\?@:;]*)");
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("max_age=(\\d+)");
    private static final Pattern PATH_PATTERN = Pattern.compile("path=([^\\s,]+)[,]?");

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String nameValuePair, String optionsString) {
        Matcher nameValuePairMatcher = this.NAME_VALUE_PAIR_PATTERN.matcher(nameValuePair);
        if (!nameValuePairMatcher.find()) {
            throw new SeleniumException("Invalid parameter: " + nameValuePair);
        }
        String name = nameValuePairMatcher.group(1);
        String value = nameValuePairMatcher.group(2);
        Matcher maxAgeMatcher = MAX_AGE_PATTERN.matcher(optionsString);
        Date maxAge = null;
        if (maxAgeMatcher.find()) {
            maxAge = new Date(System.currentTimeMillis() + (long)(Integer.parseInt(maxAgeMatcher.group(1)) * 1000));
        }
        String path = null;
        Matcher pathMatcher = PATH_PATTERN.matcher(optionsString);
        if (pathMatcher.find()) {
            path = pathMatcher.group(1);
            try {
                if (path.startsWith("http")) {
                    path = new URL(path).getPath();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        Cookie cookie = new Cookie(name, value, path, maxAge);
        driver.manage().addCookie(cookie);
        return null;
    }
}

