/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractTree;
import org.richfaces.component.AbstractTreeNode;
import org.richfaces.component.SwitchType;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.event.TreeSelectionChangeEvent;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.AjaxOptions;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.TreeEncoderFull;
import org.richfaces.renderkit.TreeRenderingContext;
import org.richfaces.renderkit.util.AjaxRendererUtils;

public abstract class TreeRendererBase
extends RendererBase
implements MetaComponentRenderer {
    static final Logger LOGGER = RichfacesLogger.RENDERKIT.getLogger();
    private static final JSReference PARAMS_JS_REF = new JSReference("params");
    private static final JSReference SOURCE_JS_REF = new JSReference("source");
    private static final JSReference COMPLETE_JS_REF = new JSReference("complete");
    private static final String SELECTION_STATE = "__SELECTION_STATE";

    public void encodeTree(FacesContext context, UIComponent component) throws IOException {
        AbstractTree tree = (AbstractTree)component;
        new TreeEncoderFull(context, tree).encode();
    }

    protected String getAjaxSubmitFunction(FacesContext context, UIComponent component) {
        AbstractTree tree = (AbstractTree)component;
        if (TreeRendererBase.getToggleTypeOrDefault(tree) != SwitchType.ajax && TreeRendererBase.getSelectionTypeOrDefault(tree) != SwitchType.ajax) {
            return null;
        }
        AjaxFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(context, component);
        ajaxFunction.setSource(SOURCE_JS_REF);
        AjaxOptions options = ajaxFunction.getOptions();
        options.set("complete", COMPLETE_JS_REF);
        options.setClientParameters(PARAMS_JS_REF);
        return ajaxFunction.toScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeSelectionStateInput(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        String selectionStateInputId = this.getSelectionStateInputId(context, component);
        writer.writeAttribute("name", (Object)selectionStateInputId, null);
        writer.writeAttribute("id", (Object)selectionStateInputId, null);
        writer.writeAttribute("class", (Object)"rf-tr-sel-inp", null);
        String selectedNodeId = "";
        AbstractTree tree = (AbstractTree)component;
        Iterator<Object> selectedKeys = tree.getSelection().iterator();
        if (selectedKeys.hasNext()) {
            Object selectionKey = selectedKeys.next();
            Object initialKey = tree.getRowKey();
            try {
                tree.setRowKey(context, selectionKey);
                if (tree.isRowAvailable()) {
                    selectedNodeId = tree.findTreeNodeComponent().getClientId(context);
                }
            }
            finally {
                try {
                    tree.setRowKey(context, initialKey);
                }
                catch (Exception e) {
                    LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (selectedKeys.hasNext()) {
            throw new IllegalArgumentException("Selection object should not contain more than one keys!");
        }
        writer.writeAttribute("value", (Object)selectedNodeId, null);
        writer.endElement("input");
    }

    protected String getSelectionStateInputId(FacesContext context, UIComponent component) {
        return component.getClientId(context) + SELECTION_STATE;
    }

    protected SwitchType getSelectionType(FacesContext context, UIComponent component) {
        AbstractTree tree = (AbstractTree)component;
        SwitchType selectionType = TreeRendererBase.getSelectionTypeOrDefault(tree);
        if (selectionType != SwitchType.ajax && selectionType != SwitchType.client) {
            throw new IllegalArgumentException(String.valueOf(selectionType));
        }
        return selectionType;
    }

    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if (!"selection".equals(metaComponentId)) {
            throw new IllegalArgumentException(metaComponentId);
        }
        PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
        writer.startUpdate(this.getSelectionStateInputId(context, component));
        this.encodeSelectionStateInput(context, component);
        writer.endUpdate();
        JSFunction function = new JSFunction("RichFaces.$", new Object[]{component.getClientId(context)});
        ExtendedPartialViewContext partialContext = ExtendedPartialViewContext.getInstance((FacesContext)context);
        partialContext.appendOncomplete((Object)(function.toScript() + ".__updateSelectionFromInput();"));
    }

    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    public void decode(FacesContext context, UIComponent component) {
        PartialViewContext pvc;
        super.decode(context, component);
        Map map = context.getExternalContext().getRequestParameterMap();
        String selectedNode = (String)map.get(this.getSelectionStateInputId(context, component));
        AbstractTree tree = (AbstractTree)component;
        Object selectionRowKey = null;
        if (!Strings.isNullOrEmpty((String)selectedNode)) {
            RowKeyContextCallback rowKeyContextCallback = new RowKeyContextCallback();
            tree.invokeOnComponent(context, selectedNode, rowKeyContextCallback);
            selectionRowKey = rowKeyContextCallback.getRowKey();
        }
        Collection<Object> selection = tree.getSelection();
        Set<Object> newSelection = null;
        if (selectionRowKey == null) {
            if (!selection.isEmpty()) {
                newSelection = Collections.emptySet();
            }
        } else if (!selection.contains(selectionRowKey)) {
            newSelection = Collections.singleton(selectionRowKey);
        }
        if (newSelection != null) {
            new TreeSelectionChangeEvent(component, (Collection)Sets.newHashSet(selection), newSelection).queue();
        }
        if ((pvc = context.getPartialViewContext()).isAjaxRequest()) {
            pvc.getRenderIds().add(tree.getClientId(context) + '@' + "selection");
        }
    }

    protected void createTreeRenderingContext(FacesContext context, UIComponent component) {
        TreeRenderingContext.create(context, (AbstractTree)component);
    }

    protected Object getClientEventHandlers(FacesContext facesContext) {
        TreeRenderingContext treeRenderingContext = TreeRenderingContext.get(facesContext);
        return treeRenderingContext.getHandlers();
    }

    protected void deleteTreeRenderingContext(FacesContext context) {
        TreeRenderingContext.delete(context);
    }

    static SwitchType getSelectionTypeOrDefault(AbstractTree tree) {
        SwitchType selectionType = tree.getSelectionType();
        if (selectionType == null) {
            selectionType = SwitchType.client;
        }
        return selectionType;
    }

    static SwitchType getToggleTypeOrDefault(AbstractTree tree) {
        SwitchType toggleType = tree.getToggleType();
        if (toggleType == null) {
            toggleType = SwitchType.DEFAULT;
        }
        return toggleType;
    }

    private final class RowKeyContextCallback
    implements ContextCallback {
        private Object rowKey;

        private RowKeyContextCallback() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            AbstractTreeNode treeNode = (AbstractTreeNode)target;
            this.rowKey = treeNode.findTreeComponent().getRowKey();
        }

        public Object getRowKey() {
            return this.rowKey;
        }
    }
}

