/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.component.AbstractPush;

/**
 *  @author Nick Belaevski
 

 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UIPush extends AbstractPush
    implements ClientBehaviorHolder    {

    public static final String COMPONENT_TYPE="org.richfaces.Push";

    public static final String COMPONENT_FAMILY="org.richfaces.Push";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UIPush() {
        super();
        setRendererType("org.richfaces.PushRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "error",
        "dataavailable"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return null;
    }


    protected enum Properties {
        address,
        ondataavailable,
        onerror
        
    }

 
    public String getAddress() {
        String value = (String) getStateHelper().eval(Properties.address);
        return value;
    }
    
    public void setAddress(String address) {
        getStateHelper().put(Properties.address, address);
    }

 
    public String getOndataavailable() {
        String value = (String) getStateHelper().eval(Properties.ondataavailable);
        return value;
    }
    
    public void setOndataavailable(String ondataavailable) {
        getStateHelper().put(Properties.ondataavailable, ondataavailable);
    }

 
    public String getOnerror() {
        String value = (String) getStateHelper().eval(Properties.onerror);
        return value;
    }
    
    public void setOnerror(String onerror) {
        getStateHelper().put(Properties.onerror, onerror);
    }

    

}