/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.rcsb.cif.model.BlockBuilder;
import org.rcsb.cif.model.CategoryBuilder;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.FloatColumnBuilder;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.ColumnBuilderImpl;

public class FloatColumnBuilderImpl<P extends CategoryBuilder<PP, PPP>, PP extends BlockBuilder<PPP>, PPP extends CifFileBuilder>
extends ColumnBuilderImpl<P, PP, PPP>
implements FloatColumnBuilder<P, PP, PPP> {
    private final List<Double> values = new ArrayList<Double>();

    public FloatColumnBuilderImpl(String categoryName, String columnName, P parent) {
        super(categoryName, columnName, parent);
    }

    @Override
    public List<Double> getValues() {
        return this.values;
    }

    @Override
    public FloatColumnBuilder<P, PP, PPP> markNextNotPresent() {
        this.values.add(0.0);
        this.mask.add(ValueKind.NOT_PRESENT);
        return this;
    }

    @Override
    public FloatColumnBuilder<P, PP, PPP> markNextUnknown() {
        this.values.add(0.0);
        this.mask.add(ValueKind.UNKNOWN);
        return this;
    }

    @Override
    public FloatColumn build() {
        return CategoryBuilder.createColumnText(this.getColumnName(), this.values, this.mask, FloatColumn.class);
    }

    @Override
    public FloatColumnBuilder<P, PP, PPP> add(double ... value) {
        DoubleStream.of(value).forEach(this.values::add);
        IntStream.range(0, value.length).mapToObj(i -> ValueKind.PRESENT).forEach(this.mask::add);
        return this;
    }

    @Override
    public P leaveColumn() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave column with undefined parent category");
        }
        this.parent.digest(this);
        return (P)this.parent;
    }
}

