/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.BlockBuilder;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.model.builder.BlockBuilderImpl;
import org.rcsb.cif.model.text.TextBlock;
import org.rcsb.cif.model.text.TextFile;

public class CifFileBuilderImpl
implements CifFileBuilder {
    private final CifFile cifFile;
    private final List<Block> blocks = new ArrayList<Block>();

    public CifFileBuilderImpl() {
        this.cifFile = new TextFile(this.blocks);
    }

    @Override
    public BlockBuilder<? extends CifFileBuilder> enterBlock(String blockHeader) {
        return new BlockBuilderImpl<CifFileBuilderImpl>(blockHeader, this);
    }

    @Override
    public void digest(BlockBuilder<? extends CifFileBuilder> builder) {
        TextBlock block = new TextBlock(builder.getCategories(), builder.getBlockHeader());
        this.blocks.add(block);
    }

    @Override
    public CifFile leaveFile() {
        return this.build();
    }

    @Override
    public CifFile build() {
        return this.cifFile;
    }

    @Override
    public CifFileBuilder addBlock(Block block) {
        this.blocks.add(block);
        return this;
    }
}

