/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.BlockBuilder;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CategoryBuilder;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.model.builder.CategoryBuilderImpl;
import org.rcsb.cif.model.text.TextBlock;
import org.rcsb.cif.model.text.TextCategory;

public class BlockBuilderImpl<P extends CifFileBuilder>
implements BlockBuilder<P> {
    private final String blockName;
    protected final Map<String, Category> categories;
    protected final P parent;

    public BlockBuilderImpl(String blockName, P parent) {
        this.blockName = blockName;
        this.categories = new LinkedHashMap<String, Category>();
        this.parent = parent;
    }

    @Override
    public CategoryBuilder<? extends BlockBuilder<P>, P> enterCategory(String categoryName) {
        return new CategoryBuilderImpl(categoryName, this);
    }

    @Override
    public String getBlockHeader() {
        return this.blockName;
    }

    @Override
    public Map<String, Category> getCategories() {
        return this.categories;
    }

    @Override
    public void digest(CategoryBuilder<? extends BlockBuilder<P>, P> builder) {
        TextCategory category = new TextCategory(builder.getCategoryName(), builder.getColumns());
        this.categories.put(builder.getCategoryName(), category);
    }

    @Override
    public P leaveBlock() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave block with undefined parent file");
        }
        this.parent.digest(this);
        return this.parent;
    }

    @Override
    public Block build() {
        return new TextBlock(this.categories, "unknown");
    }

    @Override
    public BlockBuilder<P> addCategory(Category category) {
        this.categories.put(category.getCategoryName(), category);
        return this;
    }
}

