/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.rcsb.cif.model.Column;

public interface Category {
    public String getCategoryName();

    public int getRowCount();

    public Column<?> getColumn(String var1);

    public List<String> getColumnNames();

    default public <C extends Column<?>> C getColumn(String name, Function<Column<?>, C> wrapper) {
        Column.EmptyColumn column = this.getColumn(name);
        return (C)((Column)wrapper.apply(column != null ? column : new Column.EmptyColumn(name)));
    }

    public Map<String, Column<?>> getColumns();

    default public Stream<Column<?>> columns() {
        return this.getColumns().values().stream();
    }

    default public boolean isDefined() {
        return this.getRowCount() > 0;
    }

    public static class EmptyCategory
    implements Category {
        private final String name;

        public EmptyCategory(String name) {
            this.name = name;
        }

        @Override
        public String getCategoryName() {
            return this.name;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        public Column<Void> getColumn(String name) {
            return new Column.EmptyColumn(name);
        }

        @Override
        public Map<String, Column<?>> getColumns() {
            return Collections.emptyMap();
        }

        @Override
        public List<String> getColumnNames() {
            return Collections.emptyList();
        }
    }
}

