/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.ParsingException;
import org.rcsb.cif.binary.codec.MessagePackCodec;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.LinkedCaseInsensitiveMap;
import org.rcsb.cif.model.binary.BinaryBlock;
import org.rcsb.cif.model.binary.BinaryCategory;
import org.rcsb.cif.model.binary.BinaryFile;

public class BinaryCifReader {
    public BinaryCifReader(CifOptions options) {
    }

    public CifFile read(InputStream inputStream) throws ParsingException {
        Map<String, Object> unpacked;
        try {
            unpacked = MessagePackCodec.decode(inputStream);
        }
        catch (ClassCastException e) {
            throw new ParsingException("File seems to not be in binary CIF format. Encountered unexpected cast.", e);
        }
        catch (Exception e) {
            throw new ParsingException("Parsing failed.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        String versionString = (String)unpacked.get("version");
        if (!versionString.startsWith("0.3")) {
            throw new ParsingException("Unsupported format version. Current " + versionString + ", required " + "0.3" + ".");
        }
        String encoder = (String)unpacked.get("encoder");
        Object[] rawBlocks = (Object[])unpacked.get("dataBlocks");
        ArrayList<Block> dataBlocks = new ArrayList<Block>(rawBlocks.length);
        for (Object rawBlock : rawBlocks) {
            Map map = (Map)rawBlock;
            String header = (String)map.get("header");
            LinkedCaseInsensitiveMap<Category> categories = new LinkedCaseInsensitiveMap<Category>();
            try {
                for (Object o : (Object[])map.get("categories")) {
                    Map cat = (Map)o;
                    String name = (String)cat.get("name");
                    categories.put(name.substring(1), this.createBinaryCategory(cat));
                }
                dataBlocks.add(new BinaryBlock(categories, header));
            }
            catch (NullPointerException e) {
                dataBlocks.add(new BinaryBlock(Collections.emptyMap(), header));
            }
        }
        return new BinaryFile(dataBlocks, versionString, encoder);
    }

    private Category createBinaryCategory(Map<String, Object> encodedCategory) {
        String name = ((String)encodedCategory.get("name")).substring(1);
        Object rawColumns = encodedCategory.get("columns");
        int rowCount = (Integer)encodedCategory.get("rowCount");
        Object[] encodedFields = (Object[])rawColumns;
        return new BinaryCategory(name, rowCount, encodedFields);
    }
}

