/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javassist.util.proxy.ProxyFactory;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.transformers.impl.MainMockTransformer;
import org.powermock.modules.testng.PowerMockTestCase;
import org.powermock.modules.testng.internal.PowerMockTestNGMethodHandler;
import org.powermock.modules.testng.internal.TestNGMethodFilter;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.proxyframework.RegisterProxyFramework;
import org.powermock.tests.utils.IgnorePackagesExtractor;
import org.powermock.tests.utils.TestClassesExtractor;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.testng.IObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockClassloaderObjectFactory
implements IObjectFactory {
    private final MockClassLoader mockLoader;
    private final TestClassesExtractor testClassesExtractor;
    private final IgnorePackagesExtractor ignorePackagesExtractor;

    public PowerMockClassloaderObjectFactory() {
        ArrayList<MainMockTransformer> mockTransformerChain = new ArrayList<MainMockTransformer>();
        MainMockTransformer mainMockTransformer = new MainMockTransformer();
        mockTransformerChain.add(mainMockTransformer);
        String[] classesToLoadByMockClassloader = new String[]{};
        String[] packagesToIgnore = new String[]{};
        this.mockLoader = new MockClassLoader(classesToLoadByMockClassloader, packagesToIgnore);
        this.mockLoader.setMockTransformerChain(mockTransformerChain);
        this.testClassesExtractor = new PrepareForTestExtractorImpl();
        this.ignorePackagesExtractor = new PowerMockIgnorePackagesExtractorImpl();
    }

    public Object newInstance(Constructor constructor, Object ... params) {
        MockRepository.clear();
        Class testClass = constructor.getDeclaringClass();
        this.mockLoader.addIgnorePackage(this.ignorePackagesExtractor.getPackagesToIgnore(testClass));
        this.mockLoader.addClassesToModify(this.testClassesExtractor.getTestClasses(testClass));
        try {
            this.registerProxyframework((ClassLoader)this.mockLoader);
            new MockPolicyInitializerImpl(testClass).initialize((ClassLoader)this.mockLoader);
            Class<?> testClassLoadedByMockedClassLoader = this.createTestClass(testClass);
            Constructor<?> con = testClassLoadedByMockedClassLoader.getConstructor(constructor.getParameterTypes());
            Object testInstance = con.newInstance(params);
            if (!this.extendsPowerMockTestCase(testClass)) {
                this.setInvocationHandler(testInstance);
            }
            return testInstance;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setInvocationHandler(Object testInstance) throws Exception {
        Class<?> powerMockTestNGMethodHandlerClass = Class.forName(PowerMockTestNGMethodHandler.class.getName(), false, (ClassLoader)this.mockLoader);
        Object powerMockTestNGMethodHandlerInstance = powerMockTestNGMethodHandlerClass.getConstructor(Class.class).newInstance(testInstance.getClass());
        Whitebox.invokeMethod((Object)testInstance, (String)"setHandler", (Object[])new Object[]{powerMockTestNGMethodHandlerInstance});
    }

    private Class<?> createTestClass(Class<?> actualTestClass) throws Exception {
        Class<?> testClassLoadedByMockedClassLoader = Class.forName(actualTestClass.getName(), false, (ClassLoader)this.mockLoader);
        if (this.extendsPowerMockTestCase(actualTestClass)) {
            return testClassLoadedByMockedClassLoader;
        }
        Class<?> proxyFactoryClass = Class.forName(ProxyFactory.class.getName(), false, (ClassLoader)this.mockLoader);
        Class<?> testNGMethodFilterByMockedClassLoader = Class.forName(TestNGMethodFilter.class.getName(), false, (ClassLoader)this.mockLoader);
        Object f = proxyFactoryClass.newInstance();
        Object filter = testNGMethodFilterByMockedClassLoader.newInstance();
        Whitebox.invokeMethod(f, (String)"setFilter", (Object[])new Object[]{filter});
        Whitebox.invokeMethod(f, (String)"setSuperclass", (Object[])new Object[]{testClassLoadedByMockedClassLoader});
        Class c = (Class)Whitebox.invokeMethod(f, (String)"createClass", (Object[])new Object[0]);
        return c;
    }

    private boolean extendsPowerMockTestCase(Class<?> actualTestClass) {
        return PowerMockTestCase.class.isAssignableFrom(actualTestClass);
    }

    private void registerProxyframework(ClassLoader classLoader) {
        Class<?> proxyFrameworkClass = null;
        try {
            proxyFrameworkClass = Class.forName("org.powermock.api.extension.proxyframework.ProxyFrameworkImpl", false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API internal error: org.powermock.api.extension.proxyframework.ProxyFrameworkImpl could not be located in classpath.");
        }
        Class<?> proxyFrameworkRegistrar = null;
        try {
            proxyFrameworkRegistrar = Class.forName(RegisterProxyFramework.class.getName(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Whitebox.invokeMethod(proxyFrameworkRegistrar, (String)"registerProxyFramework", (Object[])new Object[]{Whitebox.newInstance(proxyFrameworkClass)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

