/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal.template;

import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.JavaType;

public class KotlinSubstitutions
extends Substitutions {
    public KotlinSubstitutions(String code, Object[] parameters) {
        super(code, parameters);
    }

    protected String newObjectParameter(String fqn, int index) {
        return "__P__./*__p" + index + "__*/p<" + fqn + ">()";
    }

    protected String newPrimitiveParameter(String fqn, int index) {
        return this.newObjectParameter(fqn, index);
    }

    protected String newArrayParameter(JavaType elemType, int dimensions, int index) {
        int i;
        StringBuilder builder = new StringBuilder("/*__p" + index + "__*/");
        for (i = 0; i < dimensions; ++i) {
            builder.append("arrayOf");
            if (i >= dimensions - 1) continue;
            builder.append('(');
        }
        builder.append('<');
        if (elemType instanceof JavaType.Primitive) {
            builder.append(((JavaType.Primitive)elemType).getKeyword());
        } else if (elemType instanceof JavaType.FullyQualified) {
            builder.append(((JavaType.FullyQualified)elemType).getFullyQualifiedName().replace("$", "."));
        }
        builder.append(">(");
        for (i = 0; i < dimensions; ++i) {
            builder.append(')');
        }
        return builder.toString();
    }
}

