/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.CustomImportOrderStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public final class CustomImportOrderVisitor<P>
extends JavaIsoVisitor<P> {
    private final CustomImportOrderStyle style;

    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        String pkgName = cu.getPackageDeclaration() != null ? cu.getPackageDeclaration().getExpression().printTrimmed(this.getCursor()) : "";
        List originalImports = cu.getPadding().getImports();
        if (originalImports.isEmpty() || this.style.getImportOrder().isEmpty()) {
            return cu;
        }
        LinkedHashMap groupedImports = new LinkedHashMap();
        for (Object groupDef : this.style.getImportOrder()) {
            groupedImports.put((CustomImportOrderStyle.GroupWithDepth)groupDef, new ArrayList());
        }
        ArrayList<JRightPadded> unmatchedImports = new ArrayList<JRightPadded>();
        for (JRightPadded impPad : originalImports) {
            CustomImportOrderStyle.GroupWithDepth group = null;
            for (CustomImportOrderStyle.GroupWithDepth groupDef : this.style.getImportOrder()) {
                if (!this.belongsToGroup(groupDef, (JRightPadded<J.Import>)impPad, pkgName)) continue;
                group = groupDef;
                break;
            }
            if (group != null) {
                ((List)groupedImports.get(group)).add(impPad);
                continue;
            }
            unmatchedImports.add(impPad);
        }
        for (List groupImports : groupedImports.values()) {
            if (!this.style.getSortImportsInGroupAlphabetically().booleanValue() || groupImports.size() <= 1) continue;
            groupImports.sort(Comparator.comparing(irp -> ((J.Import)irp.getElement()).getQualid().printTrimmed(this.getCursor())));
        }
        ArrayList finalOrderedImports = new ArrayList();
        ArrayList allImportGroups = new ArrayList(groupedImports.values());
        if (!unmatchedImports.isEmpty()) {
            allImportGroups.add(unmatchedImports);
        }
        boolean firstGroupEmitted = false;
        boolean previousGroupWasStatic = false;
        boolean hasInsertedStaticNonStaticSeparator = false;
        int currentGroupIndex = 0;
        for (List importGroup : allImportGroups) {
            if (importGroup.isEmpty()) continue;
            boolean groupIsStatic = ((J.Import)((JRightPadded)importGroup.get(0)).getElement()).isStatic();
            if (this.style.getSeparateLineBetweenGroups().booleanValue() || !firstGroupEmitted) {
                this.normalizeGroupWhitespace(importGroup, true);
                firstGroupEmitted = true;
            }
            if (!this.style.getSeparateLineBetweenGroups().booleanValue() && ++currentGroupIndex > 1) {
                this.normalizeGroupWhitespace(importGroup, false);
                if (groupIsStatic) {
                    this.normalizeGroupWhitespace(importGroup, true);
                }
                if (previousGroupWasStatic && !hasInsertedStaticNonStaticSeparator && !groupIsStatic) {
                    this.normalizeGroupWhitespace(importGroup, true);
                    hasInsertedStaticNonStaticSeparator = true;
                }
            }
            previousGroupWasStatic = groupIsStatic;
            finalOrderedImports.addAll(importGroup);
        }
        for (int i = 0; i < finalOrderedImports.size(); ++i) {
            String originalImport;
            String orderedImport = ((J.Import)((JRightPadded)finalOrderedImports.get(i)).getElement()).print(this.getCursor());
            if (orderedImport.equals(originalImport = ((J.Import)((JRightPadded)cu.getPadding().getImports().get(i)).getElement()).print(this.getCursor()))) continue;
            cu = cu.getPadding().withImports(finalOrderedImports);
            break;
        }
        return cu;
    }

    private boolean belongsToGroup(CustomImportOrderStyle.GroupWithDepth groupDef, JRightPadded<J.Import> anImport, String pkgName) {
        J.Import imp = (J.Import)anImport.getElement();
        String importFqcn = imp.getQualid().printTrimmed(this.getCursor());
        Pattern specialPattern = Pattern.compile(this.style.getSpecialImportsRegExp());
        Pattern standardPattern = Pattern.compile(this.style.getStandardPackageRegExp());
        Pattern thirdPartyPattern = Pattern.compile(this.style.getThirdPartyPackageRegExp());
        switch (groupDef.getGroup()) {
            case STATIC: {
                return imp.isStatic();
            }
            case SAME_PACKAGE: {
                Integer depth = groupDef.getDepth();
                return depth != null && this.isSamePackage(importFqcn, pkgName, depth);
            }
            case STANDARD_JAVA_PACKAGE: {
                return !imp.isStatic() && standardPattern.matcher(importFqcn).find();
            }
            case SPECIAL_IMPORTS: {
                return !imp.isStatic() && specialPattern.matcher(importFqcn).find();
            }
            case THIRD_PARTY_PACKAGE: {
                boolean notOther = !imp.isStatic() && !specialPattern.matcher(importFqcn).find() && !standardPattern.matcher(importFqcn).find() && (groupDef.getDepth() == null || !this.isSamePackage(importFqcn, pkgName, groupDef.getDepth()));
                boolean matchesThird = thirdPartyPattern.matcher(importFqcn).find();
                return notOther && matchesThird;
            }
        }
        return false;
    }

    private boolean isSamePackage(String importFqcn, String pkgName, int depth) {
        if (depth <= 0 || pkgName.isEmpty()) {
            return false;
        }
        String[] importParts = importFqcn.split("\\.");
        String[] pkgParts = pkgName.split("\\.");
        if (importParts.length < depth || pkgParts.length < depth) {
            return false;
        }
        for (int i = 0; i < depth; ++i) {
            if (importParts[i].equals(pkgParts[i])) continue;
            return false;
        }
        return true;
    }

    private void normalizeGroupWhitespace(List<JRightPadded<J.Import>> group, boolean useDoubleNewline) {
        if (group.isEmpty()) {
            return;
        }
        JRightPadded<J.Import> first = group.get(0);
        String newWs = ((J.Import)first.getElement()).getPrefix().getWhitespace().replaceFirst("^\\n+", useDoubleNewline ? "\n\n" : "\n");
        group.set(0, (JRightPadded<J.Import>)first.withElement((Object)((J.Import)first.getElement()).withPrefix(Space.format((String)newWs))));
        for (int i = 1; i < group.size(); ++i) {
            JRightPadded<J.Import> imp = group.get(i);
            J.Import orig = (J.Import)imp.getElement();
            String ws = orig.getPrefix().getWhitespace().replaceFirst("^\\n+", "\n");
            group.set(i, (JRightPadded<J.Import>)imp.withElement((Object)orig.withPrefix(Space.format((String)ws))));
        }
    }

    @Generated
    public CustomImportOrderVisitor(CustomImportOrderStyle style) {
        this.style = style;
    }

    @Generated
    public CustomImportOrderStyle getStyle() {
        return this.style;
    }

    @Generated
    public String toString() {
        return "CustomImportOrderVisitor(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomImportOrderVisitor)) {
            return false;
        }
        CustomImportOrderVisitor other = (CustomImportOrderVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CustomImportOrderStyle this$style = this.getStyle();
        CustomImportOrderStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomImportOrderVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CustomImportOrderStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }
}

