/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.poi;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ReplaceSetBoldweightWithSetBoldRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace `Font.setBoldweight(short)` with `Font.setBold(boolean)`";
    }

    public String getDescription() {
        return "Replace `Font.setBoldweight(short)` or equivalent with `Font.setBold(boolean)`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ReplaceSetBoldweightNormalWithSetBoldFalseRecipe(), new ReplaceSetBoldweightBoldWithSetBoldTrueRecipe()});
    }

    @NullMarked
    public static class ReplaceSetBoldweightNormalWithSetBoldFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Font.setBoldweight(Font.BOLDWEIGHT_NORMAL)` with `Font.setBold(false)`";
        }

        public String getDescription() {
            return "Replace `Font.setBoldweight(Font.BOLDWEIGHT_NORMAL)` or equivalent with `Font.setBold(false)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeShort = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBoldweight((short)400);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBoldweight(#{font}.BOLDWEIGHT_NORMAL);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBoldweight(org.apache.poi.ss.usermodel.Font.BOLDWEIGHT_NORMAL);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBold(false);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeShort.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Font", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Font setBoldweight(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceSetBoldweightBoldWithSetBoldTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `Font.setBoldweight(Font.BOLDWEIGHT_BOLD)` with `Font.setBold(true)`";
        }

        public String getDescription() {
            return "Replace `Font.setBoldweight(Font.BOLDWEIGHT_BOLD)` or equivalent with `Font.setBold(true)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate beforeShort = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBoldweight((short)700);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeField = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBoldweight(#{font}.BOLDWEIGHT_BOLD);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate beforeStaticField = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBoldweight(org.apache.poi.ss.usermodel.Font.BOLDWEIGHT_BOLD);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBold(true);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.beforeShort.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.beforeStaticField.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.poi.ss.usermodel.Font", Boolean.valueOf(true)), new UsesMethod("org.apache.poi.ss.usermodel.Font setBoldweight(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

