/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

final class ControlFlowJavaPrinter<P>
extends JavaPrinter<P> {
    final List<J> nodesToPrint;

    public J visitAssert(J.Assert assert_, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)assert_, p);
        return super.visitAssert(assert_, p);
    }

    public J visitAssignment(J.Assignment assignment, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)assignment, p);
        return super.visitAssignment(assignment, p);
    }

    public J visitAssignmentOperation(J.AssignmentOperation assignOp, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)assignOp, p);
        return super.visitAssignmentOperation(assignOp, p);
    }

    public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)binary, p);
        return super.visitBinary(binary, p);
    }

    public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)block, p);
        J.Block customized = block.withPrefix(block.getEnd());
        return super.visitBlock(customized, p);
    }

    protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
        if (paddedStat == null) {
            return;
        }
        this.maybeEnableOrDisable((J)paddedStat.getElement(), p);
        super.visitStatement(paddedStat, location, p);
    }

    public J visitBreak(J.Break breakStatement, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)breakStatement, p);
        return super.visitBreak(breakStatement, p);
    }

    public J visitCase(J.Case case_, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)case_, p);
        return super.visitCase(case_, p);
    }

    public J visitCatch(J.Try.Catch catch_, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)catch_, p);
        return super.visitCatch(catch_, p);
    }

    public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)classDecl, p);
        return super.visitClassDeclaration(classDecl, p);
    }

    public J visitContinue(J.Continue continueStatement, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)continueStatement, p);
        return super.visitContinue(continueStatement, p);
    }

    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
        J.If enclosing = (J.If)this.getCursor().firstEnclosing(J.If.class);
        if (enclosing != null && enclosing.getIfCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        J.WhileLoop enclosingLoop = (J.WhileLoop)this.getCursor().firstEnclosing(J.WhileLoop.class);
        if (enclosingLoop != null && enclosingLoop.getCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        J.DoWhileLoop enclosingDoWhileLoop = (J.DoWhileLoop)this.getCursor().firstEnclosing(J.DoWhileLoop.class);
        if (enclosingDoWhileLoop != null && enclosingDoWhileLoop.getWhileCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        this.maybeEnableOrDisable((J)controlParens, p);
        return super.visitControlParentheses(controlParens, p);
    }

    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)doWhileLoop, p);
        return super.visitDoWhileLoop(doWhileLoop, p);
    }

    public J visitEnumValue(J.EnumValue enum_, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)enum_, p);
        return super.visitEnumValue(enum_, p);
    }

    public J visitEnumValueSet(J.EnumValueSet enums, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)enums, p);
        return super.visitEnumValueSet(enums, p);
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)fieldAccess, p);
        return super.visitFieldAccess(fieldAccess, p);
    }

    public J visitForLoop(J.ForLoop forLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)forLoop, p);
        return super.visitForLoop(forLoop, p);
    }

    public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)forEachLoop, p);
        return super.visitForEachLoop(forEachLoop, p);
    }

    public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
        J.Assignment parentAssignment = (J.Assignment)this.getCursor().firstEnclosing(J.Assignment.class);
        if (parentAssignment != null && parentAssignment.getVariable().unwrap() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.VariableDeclarations.NamedVariable parentNamedVariable = (J.VariableDeclarations.NamedVariable)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
        if (parentNamedVariable != null && parentNamedVariable.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.FieldAccess parentFieldAccess = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
        if (parentFieldAccess != null && parentFieldAccess.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.NewClass parentNewClass = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
        if (parentNewClass != null && parentNewClass.getClazz() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.MethodInvocation parentMethodInvocation = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
        if (parentMethodInvocation != null && parentMethodInvocation.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        this.maybeEnableOrDisable((J)ident, p);
        return super.visitIdentifier(ident, p);
    }

    public J visitIf(J.If iff, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)iff, p);
        return super.visitIf(iff, p);
    }

    public J visitElse(J.If.Else else_, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)else_, p);
        return super.visitElse(else_, p);
    }

    public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)instanceOf, p);
        return super.visitInstanceOf(instanceOf, p);
    }

    public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)lambda, p);
        return super.visitLambda(lambda, p);
    }

    public J visitLiteral(J.Literal literal, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)literal, p);
        return super.visitLiteral(literal, p);
    }

    public J visitMemberReference(J.MemberReference memberRef, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)memberRef, p);
        return super.visitMemberReference(memberRef, p);
    }

    public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)method, p);
        return super.visitMethodDeclaration(method, p);
    }

    public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)method, p);
        return super.visitMethodInvocation(method, p);
    }

    public J visitMultiCatch(J.MultiCatch multiCatch, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)multiCatch, p);
        return super.visitMultiCatch(multiCatch, p);
    }

    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)multiVariable, p);
        return super.visitVariableDeclarations(multiVariable, p);
    }

    public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)newArray, p);
        return super.visitNewArray(newArray, p);
    }

    public <T extends J> J visitParentheses(J.Parentheses<T> parens, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)parens, p);
        return super.visitParentheses(parens, p);
    }

    public J visitSwitch(J.Switch switch_, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)switch_, p);
        return super.visitSwitch(switch_, p);
    }

    public J visitSynchronized(J.Synchronized synch, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)synch, p);
        return super.visitSynchronized(synch, p);
    }

    public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)ternary, p);
        return super.visitTernary(ternary, p);
    }

    public J visitThrow(J.Throw thrown, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)thrown, p);
        return super.visitThrow(thrown, p);
    }

    public J visitTry(J.Try tryable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)tryable, p);
        return super.visitTry(tryable, p);
    }

    public J visitUnary(J.Unary unary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)unary, p);
        return super.visitUnary(unary, p);
    }

    public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)variable, p);
        return super.visitVariable(variable, p);
    }

    public J visitWhileLoop(J.WhileLoop whileLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable((J)whileLoop, p);
        return super.visitWhileLoop(whileLoop, p);
    }

    public J visitEmpty(J.Empty empty, PrintOutputCapture<P> pPrintOutputCapture) {
        J.MethodInvocation maybeParent = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
        if (maybeParent != null && maybeParent.getArguments().contains(empty)) {
            return super.visitEmpty(empty, pPrintOutputCapture);
        }
        this.maybeEnableOrDisable((J)empty, pPrintOutputCapture);
        return super.visitEmpty(empty.withPrefix(Space.build((String)" ", (List)ListUtils.concat((List)empty.getComments(), (Object)new TextComment(true, "Empty", "", Markers.EMPTY)))), pPrintOutputCapture);
    }

    private void maybeEnableOrDisable(J j, PrintOutputCapture<P> p) {
        if (this.nodesToPrint.contains(j)) {
            ControlFlowJavaPrinter.castPrint(p).enable();
        } else {
            ControlFlowJavaPrinter.castPrint(p).disable();
        }
    }

    private static <P> ControlFlowPrintOutputCapture<P> castPrint(PrintOutputCapture<P> print) {
        return (ControlFlowPrintOutputCapture)print;
    }

    @Generated
    public ControlFlowJavaPrinter(List<J> nodesToPrint) {
        this.nodesToPrint = nodesToPrint;
    }

    static class ControlFlowPrintOutputCapture<P>
    extends PrintOutputCapture<P> {
        boolean enabled;

        public ControlFlowPrintOutputCapture(P p) {
            super(p);
        }

        public PrintOutputCapture<P> append(char c) {
            if (this.enabled) {
                return super.append(c);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return super.append(c);
                }
            }
            return super.append(' ');
        }

        public PrintOutputCapture<P> append(@Nullable String text) {
            if (this.enabled) {
                return super.append(text);
            }
            if (text != null) {
                return super.append(text.replaceAll("[^ \\t\\n\\r]", " "));
            }
            return this;
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }
    }
}

