/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.property.adapter;

import com.sun.javafx.property.adapter.PropertyDescriptor;
import com.sun.javafx.property.adapter.ReadOnlyPropertyDescriptor;
import com.sun.javafx.reflect.ReflectUtil;
import java.lang.reflect.Method;

public class JavaBeanPropertyBuilderHelper {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private String propertyName;
    private Class<?> beanClass;
    private Object bean;
    private String getterName;
    private String setterName;
    private Method getter;
    private Method setter;
    private PropertyDescriptor descriptor;

    public void name(String propertyName) {
        if (propertyName == null ? this.propertyName != null : !propertyName.equals(this.propertyName)) {
            this.propertyName = propertyName;
            this.descriptor = null;
        }
    }

    public void beanClass(Class<?> beanClass) {
        if (beanClass == null ? this.beanClass != null : !beanClass.equals(this.beanClass)) {
            ReflectUtil.checkPackageAccess(beanClass);
            this.beanClass = beanClass;
            this.descriptor = null;
        }
    }

    public void bean(Object bean) {
        this.bean = bean;
        if (bean != null) {
            Class<?> newClass = bean.getClass();
            if (this.beanClass == null || !this.beanClass.isAssignableFrom(newClass)) {
                ReflectUtil.checkPackageAccess(newClass);
                this.beanClass = newClass;
                this.descriptor = null;
            }
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public void getterName(String getterName) {
        if (getterName == null ? this.getterName != null : !getterName.equals(this.getterName)) {
            this.getterName = getterName;
            this.descriptor = null;
        }
    }

    public void setterName(String setterName) {
        if (setterName == null ? this.setterName != null : !setterName.equals(this.setterName)) {
            this.setterName = setterName;
            this.descriptor = null;
        }
    }

    public void getter(Method getter) {
        if (getter == null ? this.getter != null : !getter.equals(this.getter)) {
            this.getter = getter;
            this.descriptor = null;
        }
    }

    public void setter(Method setter) {
        if (setter == null ? this.setter != null : !setter.equals(this.setter)) {
            this.setter = setter;
            this.descriptor = null;
        }
    }

    public PropertyDescriptor getDescriptor() throws NoSuchMethodException {
        if (this.descriptor == null) {
            Method setterMethod;
            if (this.propertyName == null) {
                throw new NullPointerException("Property name has to be specified");
            }
            if (this.propertyName.isEmpty()) {
                throw new IllegalArgumentException("Property name cannot be empty");
            }
            String capitalizedName = ReadOnlyPropertyDescriptor.capitalizedName(this.propertyName);
            Method getterMethod = this.getter;
            if (getterMethod == null) {
                if (this.getterName != null && !this.getterName.isEmpty()) {
                    getterMethod = this.beanClass.getMethod(this.getterName, new Class[0]);
                } else {
                    try {
                        getterMethod = this.beanClass.getMethod(IS_PREFIX + capitalizedName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        getterMethod = this.beanClass.getMethod(GET_PREFIX + capitalizedName, new Class[0]);
                    }
                }
            }
            if ((setterMethod = this.setter) == null) {
                Class<?> type = getterMethod.getReturnType();
                setterMethod = this.setterName != null && !this.setterName.isEmpty() ? this.beanClass.getMethod(this.setterName, type) : this.beanClass.getMethod(SET_PREFIX + capitalizedName, type);
            }
            this.descriptor = new PropertyDescriptor(this.propertyName, this.beanClass, getterMethod, setterMethod);
        }
        return this.descriptor;
    }
}

