/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.CppQtAbstractCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.StringUtils;

public class CppQtQHttpEngineServerCodegen
extends CppQtAbstractCodegen
implements CodegenConfig {
    protected final String SRC_DIR = "/src";
    protected final String MODEL_DIR = "/src/models";
    protected final String APIHANDLER_DIR = "/src/handlers";
    protected final String APIREQUEST_DIR = "/src/requests";
    protected String sourceFolder = "server";

    public CppQtQHttpEngineServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.outputFolder = "generated-code/cpp-qt-qhttpengine-server";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("apihandler.h.mustache", ".h");
        this.apiTemplateFiles.put("apihandler.cpp.mustache", ".cpp");
        this.apiTemplateFiles.put("apirequest.h.mustache", ".h");
        this.apiTemplateFiles.put("apirequest.cpp.mustache", ".cpp");
        this.templateDir = "cpp-qt-qhttpengine-server";
        this.embeddedTemplateDir = "cpp-qt-qhttpengine-server";
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder + "/src/models", "OAIHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder + "/src/models", "OAIHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder + "/src/models", "OAIObject.h"));
        this.supportingFiles.add(new SupportingFile("enum.mustache", this.sourceFolder + "/src/models", "OAIEnum.h"));
        this.supportingFiles.add(new SupportingFile("HttpFileElement.h.mustache", this.sourceFolder + "/src/models", "OAIHttpFileElement.h"));
        this.supportingFiles.add(new SupportingFile("HttpFileElement.cpp.mustache", this.sourceFolder + "/src/models", "OAIHttpFileElement.cpp"));
        this.supportingFiles.add(new SupportingFile("apirouter.h.mustache", this.sourceFolder + "/src/handlers", "OAIApiRouter.h"));
        this.supportingFiles.add(new SupportingFile("apirouter.cpp.mustache", this.sourceFolder + "/src/handlers", "OAIApiRouter.cpp"));
        this.supportingFiles.add(new SupportingFile("main.cpp.mustache", this.sourceFolder + "/src", "main.cpp"));
        this.supportingFiles.add(new SupportingFile("src-CMakeLists.txt.mustache", this.sourceFolder + "/src", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("README.md.mustache", this.sourceFolder, "README.MD"));
        this.supportingFiles.add(new SupportingFile("Makefile.mustache", this.sourceFolder, "Makefile"));
        this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", this.sourceFolder, "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("LICENSE.txt.mustache", this.sourceFolder, "LICENSE.txt"));
        this.typeMapping.put("file", "OAIHttpFileElement");
        this.importMapping.put("OAIHttpFileElement", "#include \"OAIHttpFileElement.h\"");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "Helpers.cpp"));
            this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "Object.h"));
            this.supportingFiles.add(new SupportingFile("enum.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "Enum.h"));
            this.supportingFiles.add(new SupportingFile("HttpFileElement.h.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "HttpFileElement.h"));
            this.supportingFiles.add(new SupportingFile("HttpFileElement.cpp.mustache", this.sourceFolder + "/src/models", this.modelNamePrefix + "HttpFileElement.cpp"));
            this.supportingFiles.add(new SupportingFile("apirouter.h.mustache", this.sourceFolder + "/src/handlers", this.modelNamePrefix + "ApiRouter.h"));
            this.supportingFiles.add(new SupportingFile("apirouter.cpp.mustache", this.sourceFolder + "/src/handlers", this.modelNamePrefix + "ApiRouter.cpp"));
            this.supportingFiles.add(new SupportingFile("main.cpp.mustache", this.sourceFolder + "/src", "main.cpp"));
            this.supportingFiles.add(new SupportingFile("src-CMakeLists.txt.mustache", this.sourceFolder + "/src", "CMakeLists.txt"));
            this.supportingFiles.add(new SupportingFile("README.md.mustache", this.sourceFolder, "README.MD"));
            this.supportingFiles.add(new SupportingFile("Makefile.mustache", this.sourceFolder, "Makefile"));
            this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", this.sourceFolder, "Dockerfile"));
            this.supportingFiles.add(new SupportingFile("LICENSE.txt.mustache", this.sourceFolder, "LICENSE.txt"));
            this.typeMapping.put("file", this.modelNamePrefix + "HttpFileElement");
            this.importMapping.put(this.modelNamePrefix + "HttpFileElement", "#include \"" + this.modelNamePrefix + "HttpFileElement.h\"");
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "cpp-qt-qhttpengine-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Qt C++ Server using the QHTTPEngine HTTP Library.";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/src/models/" + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/src/handlers/" + this.apiPackage().replace("::", File.separator);
    }

    private String requestFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/src/requests/" + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.contains("apirequest")) {
            result = result.replace("ApiHandler", "ApiRequest");
            result = result.replace(this.apiFileFolder(), this.requestFileFolder());
        }
        return result;
    }

    @Override
    public String toApiFilename(String name) {
        return this.modelNamePrefix + this.sanitizeName(StringUtils.camelize(name)) + "ApiHandler";
    }
}

