/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.xmla.server.impl;

import java.util.AbstractList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeList<T>
extends AbstractList<T> {
    private final List<? extends T>[] lists;

    public CompositeList(List<? extends T> ... lists) {
        this.lists = lists;
    }

    public static <T> CompositeList<T> of(List<? extends T> ... lists) {
        return new CompositeList<T>(lists);
    }

    @Override
    public T get(int index) {
        int n = 0;
        for (List<T> list : this.lists) {
            int next = n + list.size();
            if (index < next) {
                return list.get(index - n);
            }
            n = next;
        }
        throw new IndexOutOfBoundsException("index" + index + " out of bounds in list of size " + n);
    }

    @Override
    public int size() {
        int n = 0;
        for (List<T> list : this.lists) {
            n += list.size();
        }
        return n;
    }
}

