package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * Possible enhancement:
 * - generateParentMethod can generate attribut method access that call
 *   the same method on parent instance class. For that we must have one attribut
 *   instance by parent. This attribut we must be created in setWikitty method
 *   and used same wikitty object.
 *
 * @author poussin
 */
public class BusinessEntityAbstractGenerator extends WikengoCommonGenerator {
	
	private static final Log log = LogFactory.getLog(BusinessEntityAbstractGenerator.class);

    static protected Pattern extractTypeOnCollection = Pattern.compile("\\w*<(\\w+)>");

    protected String EXT_NAME;

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info( "Filename for " + clazz.getName() + " is " +  fqn.replace('.', File.separatorChar) + ".java");
        return fqn.replace('.', File.separatorChar) + "Abstract.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isBusinessEntity(clazz)) {
        	log.info( clazz.getName() + " is not a business entity");
            return;
        }

        log.info("Generate Business entity abstract" + clazz.getName() + "... ");
        generateCopyright(output);

        EXT_NAME = "EXT_" + clazz.getName().toUpperCase();

        String packageName = clazz.getPackageName();
        String name = clazz.getName() + "Abstract";
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        addImport(clazz);
        addImport(superClass);
        addImport("org.nuiton.wikitty.WikittyUtil");
        addImport("org.nuiton.wikitty.Wikitty");
        addImport("org.nuiton.wikitty.BusinessEntityWikitty");
        addImport("org.nuiton.wikitty.WikittyExtension");
        addImport(Collection.class);
        addImport(Collections.class);
        addImport(List.class);
        addImport(ArrayList.class);
        String parentImpl = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                addImport(parent);
                parentImpl = parent.getQualifiedName() + "Impl";
                addImport(parentImpl);
                addImport(parent.getQualifiedName() + "Abstract");
            }
        }
        lookForAttributeImports(clazz);
        generateImports(output, packageName);

        generateClazzDocumentation(output, clazz);
        String extendsString = " extends " + getType( parentImpl != null ? parentImpl : "org.nuiton.wikitty.BusinessEntityWikitty" );

        String implementsString = "implements " + getType(clazz.getQualifiedName());
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                implementsString += ", " + getType(parent.getQualifiedName());
            }
        }

output.write("public abstract class "+name+""+extendsString+" "+implementsString+" {\n");
output.write("\n");
output.write("");

        String svUID = GeneratorUtil.computeSerialVersionUID(clazz);
output.write("    private static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");
        
        generateWikittyExtension(output, clazz);

        generateStaticAttributes(output, clazz);

output.write("\n");
output.write("	public "+name+"() {\n");
output.write("		super();\n");
output.write("	}\n");
output.write("\n");
output.write("    public "+name+"(BusinessEntityWikitty wi) {\n");
output.write("		super(wi.getWikitty());\n");
output.write("	}\n");
output.write("\n");
output.write(" 	public "+name+"(Wikitty wi) {\n");
output.write("		super(wi);\n");
output.write("	}\n");
output.write("\n");
output.write("");

        generateAttributeAccessMethod(output, clazz);
        
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                generateParentMethod(output, parent);
            }
        }

output.write("    @Override\n");
output.write("    public Collection<WikittyExtension> getStaticExtensions() {\n");
output.write("        return extensions;\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Check equality on all field of this extension, and only those.\n");
output.write("     */\n");
output.write("    static public boolean equals(Wikitty w1, Wikitty w2) {\n");
output.write("        boolean result = true;\n");
output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.isNavigable() && !attr.isStatic() &&
                    (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
output.write("        if (result) {\n");
output.write("            Object f1 = w1.getFieldAsObject("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+");\n");
output.write("            Object f2 = w2.getFieldAsObject("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+");\n");
output.write("            result = f1 == f2 || (f1 != null && f1.equals(f2));\n");
output.write("        }\n");
output.write("");
            }
        }
output.write("\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("} //"+name+"\n");
output.write("");

    }
    
    
    
    // Utilitarian methods

    public void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.isNavigable() && !attr.isStatic()
                    && (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
        		if ((attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1)) {
        			//TODO ymartel 20090812: when dataType "List", "Set" or "Collection" in model, must be here!
        			generateCollectionAttributeAccessors(output, clazz, attr);
        		} else {
        			generateWikittyAttributeAccessors(output, clazz, attr);
        		}
            }
        }
    }

    private void generateWikittyExtension(Writer output,
            ObjectModelClass clazz) throws IOException {
    	String version = clazz.getTagValue("version");
    	
    	// Since wikitty 1.3, version need to be dotted
    	if ( version == null ) {
    		version = "1.0";
    	}
    	
    	// get requires from parent
    	String requires = null;
    	String separator = "";
    	for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                String parentExtName = "EXT_" + parent.getName().toUpperCase();
                
                if (requires == null) {
                    requires = "";
                }
                
                requires += separator + parent.getName() + "." + parentExtName;
                // dans le cas où on aurait un heritage multiple :)
                // FIXME EC-20100420 gerer les extensions multiples
                separator = " + \",\" /* FIXME Multiples extentions are not yet supported */ + ";
            }
    	}

output.write("    static final public List<WikittyExtension> extensions;\n");
output.write("    static final public WikittyExtension extension"+clazz.getName()+" =\n");
output.write("        new WikittyExtension("+EXT_NAME+", \""+version+"\", "+requires+",\n");
output.write("		    WikittyUtil.buildFieldMapExtension(");

    	separator = "";
    	for (ObjectModelAttribute attr : clazz.getAttributes()) {
    		if (attr.isNavigable() && !attr.isStatic() &&
                    (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
output.write(""+separator+"\n");
output.write("				");
    			generateAttribute(output, attr);
    			separator = ",";
    		}
    	}
output.write("));\n");
output.write("    static {\n");
output.write("        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();\n");
output.write("");
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
output.write("\n");
output.write("        exts.addAll("+parent.getName()+"Abstract.extensions);\n");
output.write("");
            }
        }
        
        // EC-20100420 add current extension after parent ones
        // if current is loaded before required extension
        // load failed because required extension is missing
output.write("        // current after requires ones\n");
output.write("        exts.add(extension"+clazz.getName()+");\n");
output.write("\n");
output.write("        extensions = Collections.unmodifiableList(exts);\n");
output.write("    }\n");
output.write("");
    }

    private void generateAttribute(Writer output, ObjectModelAttribute attr)
            throws IOException {
        String attrType = computeType(attr);
        if (EugengoUtils.notEmpty(attrType)) {
            attrType = getType(attrType);
        } else {
            return;
        }

        String attrName = attr.getName();
        String card = "";

        //TODO ymartel 20090812: a better way to manage those DataTypes in the model?
        if (attrType.contains("Collection") || attrType.contains("List") || attrType.contains("Set")) {
        	card = "[0-*]";
            // List<String>
            Matcher match = extractTypeOnCollection.matcher(attrType);
            if (match.matches()) {
                attrType = match.group(1);
            }
        }

        if (!commonTypes.contains(attrType)) {
        	attrType = "Wikitty";
        } else if(commonNumerics.contains(attrType)) {
            attrType = "Numeric";
        } else if(commonStrings.contains(attrType)) {
            attrType = "String";
        }


        int maxMultiplicity = attr.getMaxMultiplicity();
		if ((maxMultiplicity != 0 && maxMultiplicity != 1)){
        	card = "[" + attr.getMinMultiplicity() + "-";
        	if (maxMultiplicity == -1) {
        		card += "*]";
        	} else {
        		card += maxMultiplicity + "]";
        	}
        }

		// FIXME EC-20100420 attr.isUnique() always return true for
		// attributes (maybe use tagValue instead)
        String unique = "";
        boolean isCollection = (attr.getMaxMultiplicity() != 0
                && attr.getMaxMultiplicity() != 1);
        if (isCollection && attr.isUnique()) {
            unique = " unique=true";
        }

        String tagValues = "";
        for (String tag : attr.getTagValues().keySet()) {
            String value = attr.getTagValue(tag);
            value = value.replaceAll("\n", "\\n");
            value = value.replaceAll("\"", "\\\"");

            tagValues += " " + tag + "=\\\"" + value + "\\\"";
        }

output.write("\""+attrType+" "+attrName+""+card+""+unique+""+tagValues+"\"");
    }

    private void generateParentMethod(Writer output,
            ObjectModelClass clazz) throws IOException {

        // we must generate method for parent of parent
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                generateParentMethod(output, parent);
            }
        }

        // generate method acces for parent attribut
        generateAttributeAccessMethod(output, clazz);
    }
    
    protected void generateWikittyAttributeAccessors(Writer output, 
            ObjectModelClass clazz, ObjectModelAttribute attr) throws IOException {

        EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();

    	String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}
    	
    	// FIXME EC-20100421 cette methode peut retourner List<String>
    	// et generer la methode getWikitty().getFieldAsList<String>()
    	// qui ne peut pas compiler
        String methodAccessName = getFieldAccessMethodName(attr);

        String attrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(attrName);

output.write("\n");
output.write("    public void set"+attrNameCapitalized+"("+attrType+" "+attrName+") {\n");
output.write("        Object oldValue = getField("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+");\n");
output.write("        getWikitty().setField("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", "+attrName+");\n");
output.write("        getPropertyChangeSupport().firePropertyChange(FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", oldValue, "+attrName+");\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+attrType+" get"+attrNameCapitalized+"() {\n");
output.write("        "+attrType+" result = getWikitty().getFieldAs"+methodAccessName+"("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+");\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }

    /**
     * Give the string to put after getFieldAs???, only some type is accepted
     * and we must convert BusinessEntity to Wikitty string
     * @param type
     * @return
     */
    protected String getFieldAccessMethodName(ObjectModelAttribute attr) {
        String result = computeType(attr);
        result = getType(result, true);

        boolean isCollection = (attr.getMaxMultiplicity() != 0
                && attr.getMaxMultiplicity() != 1);
        if (isCollection) {
            if (attr.isUnique()) {
                result = "Set";
            } else {
                result = "List";
            }
        } else {
            // test for Date
            if ("java.util.Date".equals(result) || "Date".equals(result)) {
                result = "Date";
            } else if (getModel().hasClass(result)) { // test for Wikitty object
                ObjectModelClass fieldClass = getModel().getClass(result);
                if (EugengoUtils.isBusinessEntity(fieldClass)) {
                    // for wikittyDto we use String for Id
                    result = "Wikitty";
                }
            } else if (null != getModel().getEnumeration(result)) {
                result = "String";
            }
        }
        result = EugengoUtils.toUpperCaseFirstLetter(result);

        return result;
    }

    protected void generateCollectionAttributeAccessors(Writer output, 
    		ObjectModelClass clazz, ObjectModelAttribute attr) throws IOException {

        EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();

        String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}

        // get collection element type for add and remove method arguement type
        String elementType = getType(attr.getType(), true);

        String methodAccessName = getFieldAccessMethodName(attr);

    	String attrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(attrName);
output.write("    public "+attrType+" get"+attrNameCapitalized+"() {\n");
output.write("        "+attrType+" result = getWikitty().getFieldAs"+methodAccessName+"("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", "+getClassAndGeneric(attrType)[1]+".class);\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    public void add"+attrNameCapitalized+"("+elementType+" element) {\n");
output.write("        getWikitty().addToField("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", element);\n");
output.write("        getPropertyChangeSupport().firePropertyChange(FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", null, get"+attrNameCapitalized+"());\n");
output.write("    }\n");
output.write("    \n");
output.write("    public void remove"+attrNameCapitalized+"("+elementType+" element) {\n");
output.write("        getWikitty().removeFromField("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", element);\n");
output.write("        getPropertyChangeSupport().firePropertyChange(FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", null, get"+attrNameCapitalized+"());\n");
output.write("    }\n");
output.write("    \n");
output.write("    public void clear"+attrNameCapitalized+"() {\n");
output.write("        getWikitty().clearField("+EXT_NAME+", FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+");\n");
output.write("        getPropertyChangeSupport().firePropertyChange(FIELD_"+clazz.getName().toUpperCase()+"_"+attr.getName().toUpperCase()+", null, get"+attrNameCapitalized+"());\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }
    
    private static Set<String> commonNumerics;
    static {
        commonNumerics = new HashSet<String>();
        commonNumerics.add("byte");
        commonNumerics.add("Byte");
        commonNumerics.add("short");
        commonNumerics.add("Short");
        commonNumerics.add("int");
        commonNumerics.add("Integer");
        commonNumerics.add("long");
        commonNumerics.add("Long");
        commonNumerics.add("float");
        commonNumerics.add("Float");
        commonNumerics.add("double");
        commonNumerics.add("Double");
    }

    private static Set<String> commonStrings;
    static {
        commonStrings = new HashSet<String>();
        commonStrings.add("char");
        commonStrings.add("Char");
        commonStrings.add("String");
    }

    private static Set<String> commonTypes;
    static {
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
    }

}
