/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.wikitty.generator.EugengoUtils;
import org.nuiton.wikitty.generator.WikengoCommonGenerator;

public class BusinessEntityInterfaceGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(BusinessEntityInterfaceGenerator.class);
    protected String EXT_NAME;

    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info((Object)("Filename for " + clazz.getName() + " is " + fqn.replace('.', File.separatorChar) + ".java"));
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)clazz)) {
            log.info((Object)(clazz.getName() + " is not a business entity"));
            return;
        }
        log.info((Object)("Generate Business entity " + clazz.getName() + "... "));
        this.generateCopyright(output);
        this.EXT_NAME = "EXT_" + clazz.getName().toUpperCase();
        String packageName = clazz.getPackageName();
        String name = clazz.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(superClass);
        this.addImport("org.nuiton.wikitty.BusinessEntity");
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.addImport(parent);
        }
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        String extendsString = "extends " + this.getType("org.nuiton.wikitty.BusinessEntity");
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            extendsString = extendsString + ", " + this.getType(parent.getName());
        }
        output.write("public interface " + name + " " + extendsString + " {\n");
        output.write("\n");
        output.write("    static final public String " + this.EXT_NAME + " = \"" + clazz.getName() + "\";\n");
        output.write("\n");
        output.write("");
        this.generateFieldNameConstant(output, clazz);
        this.generateStaticAttributes(output, clazz);
        this.generateAttributeAccessMethod(output, clazz);
        this.generateInterfaceOperations(output, (ObjectModelClassifier)clazz);
        output.write("\n");
        output.write("} //" + name + "\n");
        output.write("");
    }

    private void generateFieldNameConstant(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            output.write("    static final public String FIELD_" + attr.getName().toUpperCase() + " = \"" + attr.getName() + "\";\n");
            output.write("    static final public String FQ_FIELD_" + attr.getName().toUpperCase() + " = " + this.EXT_NAME + " + \"." + attr.getName() + "\";\n");
            output.write("");
        }
    }

    public void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            if (attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1) {
                this.generateCollectionAttributeAccessors(output, attr);
                continue;
            }
            this.generateWikittyAttributeAccessors(output, attr);
        }
    }

    protected void generateWikittyAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("\n");
        output.write("    public void set" + attrNameCapitalized + "(" + attrType + " " + attrName + ");\n");
        output.write("    public " + attrType + " get" + attrNameCapitalized + "();\n");
        output.write("\n");
        output.write("");
    }

    protected void generateCollectionAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String elementType = this.getType(attr.getType(), true);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("    public " + attrType + " get" + attrNameCapitalized + "();\n");
        output.write("    public void add" + attrNameCapitalized + "(" + elementType + " element);\n");
        output.write("    public void remove" + attrNameCapitalized + "(" + elementType + " element);\n");
        output.write("    public void clear" + attrNameCapitalized + "();\n");
        output.write("\n");
        output.write("");
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String opName = op.getName();
            output.write("    /**\n");
            output.write("");
            if (EugengoUtils.hasDocumentation((ObjectModelElement)op)) {
                String opDocumentation = op.getDocumentation();
                output.write("     * " + opName + " : " + opDocumentation + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write(" ");
            }
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            output.write("     */\n");
            output.write("    " + opVisibility + " " + opType + " " + opName + "(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramType = param.getType();
                output.write("" + comma + "" + paramType + " " + paramName + "");
                comma = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write(";\n");
            output.write("\n");
            output.write("");
        }
    }
}

