/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.nuiton.wikitty.query.function.FunctionFieldValue;
import org.nuiton.wikitty.query.function.FunctionValue;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;
import org.parboiled.BaseParser;
import org.parboiled.Context;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParseTreeUtils;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Var;

@BuildParseTree
public class WikittyQueryParser
extends BaseParser<Object> {
    public static final String AS = "AS";
    public static final String DATE = "DATE";
    public static final String SELECT = "SELECT";
    public static final String WHERE = "WHERE";
    public static final String IN = "IN";
    public static final String LITERAL_OPEN_SIMPLE = "'";
    public static final String LITERAL_CLOSE_SIMPLE = "'";
    public static final String LITERAL_OPEN_DOUBLE = "\"";
    public static final String LITERAL_CLOSE_DOUBLE = "\"";
    public static final String NULL = "NULL";
    public static final String TO = "TO";
    public static final String FALSE = "FALSE";
    public static final String TRUE = "TRUE";
    public static final String UNLIKE = "UNLIKE";
    public static final String AND = "AND";
    public static final String COMMA = ",";
    public static final String CURLY_BRACKET_CLOSE = "}";
    public static final String CURLY_BRACKET_OPEN = "{";
    public static final String EQUALS = "=";
    public static final String EQUALS_IGNORE_CASE_AND_ACCENT = "~";
    public static final String GREATER = ">";
    public static final String GREATER_OR_EQUALS = ">=";
    public static final String LESS = "<";
    public static final String LESS_OR_EQUALS = "<=";
    public static final String LIKE = "LIKE";
    public static final String NOT = "NOT";
    public static final String NOT_EQUALS = "!=";
    public static final String NOT_EQUALS_IGNORE_CASE_AND_ACCENT = "!~";
    public static final String OR = "OR";
    public static final String BRACKET_CLOSE = ")";
    public static final String BRACKET_OPEN = "(";
    public static final String SQUARE_BRACKET_CLOSE = "]";
    public static final String SQUARE_BRACKET_OPEN = "[";
    public static final String OFFSET = "#OFFSET";
    public static final String LIMIT = "#LIMIT";
    public static final String DEPTH = "#DEPTH";
    public Rule icOFFSET = this.IgnoreCase("#OFFSET");
    public Rule icLIMIT = this.IgnoreCase("#LIMIT");
    public Rule icDEPTH = this.IgnoreCase("#DEPTH");
    public Rule icEXTENSION = this.IgnoreCase(Element.EXTENSION.getValue());
    public Rule icID = this.IgnoreCase(Element.ID.getValue());
    public Rule icNOT = this.IgnoreCase("NOT");
    public Rule icAND = this.IgnoreCase("AND");
    public Rule icOR = this.IgnoreCase("OR");
    public Rule icSELECT = this.IgnoreCase("SELECT");
    public Rule icWHERE = this.IgnoreCase("WHERE");
    public Rule icIN = this.IgnoreCase("IN");
    public Rule icTO = this.IgnoreCase("TO");
    public Rule icFALSE = this.IgnoreCase("FALSE");
    public Rule icTRUE = this.IgnoreCase("TRUE");
    public Rule icLIKE = this.IgnoreCase("LIKE");
    public Rule icUNLIKE = this.IgnoreCase("UNLIKE");
    public Rule icNULL = this.IgnoreCase("NULL");
    public Rule icDATE = this.IgnoreCase("DATE");
    public Rule icAS = this.IgnoreCase("AS");
    private static Log log = LogFactory.getLog(WikittyQueryParser.class);
    protected Map<String, String> alias = new LinkedHashMap<String, String>();

    boolean debug(String text, Context context) {
        System.out.println("DEBUG(" + context.getCurrentIndex() + "):" + text + "  nodes:" + context.getSubNodes());
        return true;
    }

    public Map<String, String> getAlias() {
        return Collections.unmodifiableMap(this.alias);
    }

    public WikittyQueryParser setAlias(Map<String, String> alias) {
        this.alias = new LinkedHashMap<String, String>();
        if (alias != null) {
            this.alias.putAll(alias);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikittyQueryParser addAlias(String aliasName, String aliasValue) {
        Map<String, String> map = this.alias;
        synchronized (map) {
            this.alias.put(aliasName, aliasValue);
        }
        return this;
    }

    public WikittyQueryParser clearAlias() {
        this.alias = new LinkedHashMap<String, String>();
        return this;
    }

    public WikittyQuery parseQuery(String queryString) {
        WikittyQuery result = WikittyQueryParser.parse(queryString, this.alias);
        return result;
    }

    public static WikittyQuery parse(String queryString) {
        WikittyQuery result = WikittyQueryParser.parse(queryString, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikittyQuery parse(String queryString, Map<String, String> alias) {
        WikittyQueryParser parser;
        ParsingResult result;
        if ((queryString = StringUtils.strip((String)queryString)) == null) {
            queryString = "";
        }
        if (alias != null) {
            String queryStringInit = queryString;
            Map<String, String> map = alias;
            synchronized (map) {
                for (Map.Entry<String, String> a : alias.entrySet()) {
                    queryString = queryString.replaceAll(a.getKey(), a.getValue());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("QueryString \n'%s' become after alias \n'%s'\naliases are %s", queryStringInit, queryString, alias));
            }
        }
        if ((result = new ReportingParseRunner((parser = (WikittyQueryParser)Parboiled.createParser(WikittyQueryParser.class, (Object[])new Object[0])).start()).run(queryString)).hasErrors() || !result.matched) {
            System.out.println("\nParse Errors:\n" + ErrorUtils.printParseErrors((ParsingResult)result));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\nParse Tree:\n" + ParseTreeUtils.printNodeTree((ParsingResult)result) + '\n'));
        }
        WikittyQuery query = (WikittyQuery)result.resultValue;
        return query;
    }

    protected Element toElement(String v) {
        Element result = Element.get(v);
        return result;
    }

    protected int toInt(String v) {
        int result = Integer.parseInt(v);
        return result;
    }

    protected String removeQuote(String s) {
        String result = s;
        if (StringUtils.startsWithAny((CharSequence)s, (CharSequence[])new CharSequence[]{"'", "\""}) && StringUtils.endsWithAny((CharSequence)s, (CharSequence[])new CharSequence[]{"'", "\""})) {
            result = StringUtils.substring((String)s, (int)1, (int)-1);
        }
        return result;
    }

    protected String toDate(Object s) {
        if (s instanceof ConditionValueString) {
            s = ((ConditionValueString)s).getValue();
        }
        Date d = WikittyUtil.toDate(s);
        String result = WikittyUtil.toString(d);
        return result;
    }

    protected Object addToList(Object list, Object e) {
        ((Collection)list).add(e);
        return list;
    }

    Rule start() {
        return this.Sequence(this.FirstOf(this.or(), this.empty(), new Object[0]), this.push(new WikittyQuery((Condition)this.pop())), new Object[]{this.offset(), this.limit(), this.depth(), this.space(), EOI});
    }

    Rule empty() {
        return this.Sequence(EMPTY, this.push(new True()), new Object[0]);
    }

    Rule offset() {
        return this.Optional(this.space(), this.icOFFSET, new Object[]{this.FirstOf(EQUALS, this.space(), new Object[0]), this.OneOrMore(this.AnyOf("1234567890")), this.push(((WikittyQuery)this.pop()).setOffset(this.toInt(this.match())))});
    }

    Rule limit() {
        return this.Optional(this.space(), this.icLIMIT, new Object[]{this.FirstOf(EQUALS, this.space(), new Object[0]), this.OneOrMore(this.AnyOf("1234567890")), this.push(((WikittyQuery)this.pop()).setLimit(this.toInt(this.match())))});
    }

    Rule depth() {
        return this.Optional(this.space(), this.icDEPTH, new Object[]{this.FirstOf(EQUALS, this.space(), new Object[0]), this.OneOrMore(this.AnyOf("1234567890")), this.push(((WikittyQuery)this.pop()).setWikittyFieldSearchDepth(this.toInt(this.match())))});
    }

    Rule or() {
        return this.Sequence(this.and(), this.ZeroOrMore(this.space(), this.icOR, new Object[]{this.space(), this.and(), this.push(new Or((Condition)this.pop(1), (Condition)this.pop()))}), new Object[0]);
    }

    Rule and() {
        return this.Sequence(this.term(), this.ZeroOrMore(this.FirstOf(this.Sequence(this.space(), this.icAND, new Object[]{this.space()}), this.Sequence(this.space(), this.TestNot(this.icOR), new Object[0]), new Object[0]), this.term(), new Object[]{this.push(new And((Condition)this.pop(1), (Condition)this.pop()))}), new Object[0]);
    }

    Rule term() {
        return this.FirstOf(this.condition(), this.Parens(), new Object[0]);
    }

    Rule Parens() {
        return this.Sequence(this.space(), BRACKET_OPEN, new Object[]{this.space(), this.or(), this.space(), BRACKET_CLOSE, this.space()});
    }

    Rule condition() {
        return this.FirstOf(this.not(), this.isNull(), new Object[]{this.isNotNull(), this.select(), this.greatereq(), this.lesseq(), this.between(), this.containsAll(), this.containsOne(), this.eq(), this.neq(), this.eqIgnoreCaseAndAccent(), this.neqIgnoreCaseAndAccent(), this.less(), this.greater(), this.like(), this.notlike(), this.rTrue(), this.rFalse(), this.keyword()});
    }

    Rule not() {
        return this.Sequence(this.space(), this.icNOT, new Object[]{this.space(), this.term(), this.push(new Not((Condition)this.pop()))});
    }

    Rule isNull() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), this.icNULL, this.push(new Null(this.toElement(this.pop().toString())))});
    }

    Rule isNotNull() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), NOT_EQUALS, this.space(), this.icNULL, this.push(new NotNull(this.toElement(this.pop().toString())))});
    }

    Rule eq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), this.value(), this.push(new Equals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule neq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), NOT_EQUALS, this.space(), this.value(), this.push(new NotEquals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule eqIgnoreCaseAndAccent() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS_IGNORE_CASE_AND_ACCENT, this.space(), this.value(), this.push(new Equals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop(), true))});
    }

    Rule neqIgnoreCaseAndAccent() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), NOT_EQUALS_IGNORE_CASE_AND_ACCENT, this.space(), this.value(), this.push(new NotEquals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop(), true))});
    }

    Rule less() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), LESS, this.space(), this.value(), this.push(new Less(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule lesseq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), LESS_OR_EQUALS, this.space(), this.value(), this.push(new LessOrEquals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule greater() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), GREATER, this.space(), this.value(), this.push(new Greater(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule greatereq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), GREATER_OR_EQUALS, this.space(), this.value(), this.push(new GreaterOrEquals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule like() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), this.icLIKE, this.space(), this.value(), this.push(new Like(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule notlike() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), this.icUNLIKE, this.space(), this.value(), this.push(new Unlike(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule between() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), SQUARE_BRACKET_OPEN, this.space(), this.value(), this.space(), this.icTO, this.space(), this.value(), this.space(), SQUARE_BRACKET_CLOSE, this.push(new Between(this.toElement(this.pop(2).toString()), (ConditionValue)this.pop(1), (ConditionValue)this.pop()))});
    }

    Rule containsAll() {
        Var elems = new Var(new LinkedList());
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), SQUARE_BRACKET_OPEN, this.space(), this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space(), this.ZeroOrMore(COMMA, this.space(), new Object[]{this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space()}), SQUARE_BRACKET_CLOSE, this.push(new ContainsAll(this.toElement(this.pop().toString()), (Collection)elems.get()))});
    }

    Rule containsOne() {
        Var elems = new Var(new LinkedList());
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), CURLY_BRACKET_OPEN, this.space(), this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space(), this.ZeroOrMore(COMMA, this.space(), new Object[]{this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space()}), CURLY_BRACKET_CLOSE, this.push(new ContainsOne(this.toElement(this.pop().toString()), (Collection)elems.get()))});
    }

    Rule select() {
        return this.Sequence(this.icSELECT, this.space(), new Object[]{this.functionOrFieldList(), this.space(), this.FirstOf(this.Sequence(this.icWHERE, this.space(), new Object[]{this.term()}), this.empty(), new Object[0]), this.push(new Select((WikittyQueryFunction)this.pop(1), (Condition)this.pop()))});
    }

    Rule functionOrFieldList() {
        return this.Sequence(this.push(new LinkedList()), this.functionOrFieldOrString(), new Object[]{this.ZeroOrMore(COMMA, this.functionOrFieldOrString(), new Object[0]), this.push(WikittyQueryFunction.createFusionIfNeeded((List)this.pop()))});
    }

    Rule functionOrFieldOrString() {
        return this.Sequence(this.FirstOf(this.function(), this.fieldFunction(), new Object[]{this.stringFunction()}), this.push(this.addToList(this.pop(1), this.pop())), new Object[0]);
    }

    Rule function() {
        Var alias = new Var();
        return this.Sequence(this.OneOrMore(this.FirstOf(this.field(), this.AnyOf("#"), new Object[0])), this.push(this.match()), new Object[]{BRACKET_OPEN, this.push(new LinkedList()), this.Optional(this.functionOrFieldOrString(), this.ZeroOrMore(COMMA, this.functionOrFieldOrString(), new Object[0]), new Object[0]), BRACKET_CLOSE, this.Optional(this.alias((Var<String>)alias)), this.push(WikittyQueryFunction.create(this.pop(1).toString(), (String)alias.get(), (List)this.pop()))});
    }

    Rule fieldFunction() {
        Var alias = new Var();
        return this.Sequence(this.field(), this.push(this.toElement(this.match())), new Object[]{this.Optional(this.alias((Var<String>)alias)), this.push(new FunctionFieldValue((String)alias.get(), this.pop().toString()))});
    }

    Rule stringFunction() {
        Var alias = new Var();
        return this.Sequence(this.valueText(), this.Optional(this.alias((Var<String>)alias)), new Object[]{this.push(new FunctionValue((String)alias.get(), ((ConditionValueString)this.pop()).getValue()))});
    }

    Rule alias(Var<String> alias) {
        return this.Sequence(this.space(), this.icAS, new Object[]{this.space(), this.field(), alias.set((Object)this.match())});
    }

    Rule element() {
        return this.Sequence(this.field(), this.push(this.toElement(this.match())), new Object[0]);
    }

    Rule keyword() {
        return this.Sequence(this.value(), this.push(new Keyword().addCondition((ConditionValue)this.pop())), new Object[0]);
    }

    Rule field() {
        return this.OneOrMore(this.FirstOf(this.CharRange('0', '9'), this.CharRange('a', 'z'), new Object[]{this.CharRange('A', 'Z'), this.AnyOf("_.*")}));
    }

    Rule rTrue() {
        return this.Sequence(this.icTRUE, this.push(new True()), new Object[0]);
    }

    Rule rFalse() {
        return this.Sequence(this.icFALSE, this.push(new False()), new Object[0]);
    }

    Rule value() {
        return this.FirstOf(this.select(), this.date(), new Object[]{this.valueText()});
    }

    Rule date() {
        return this.Sequence(this.icDATE, BRACKET_OPEN, new Object[]{this.valueText(), BRACKET_CLOSE, this.push(new ConditionValueString(this.toDate(this.pop())))});
    }

    Rule valueText() {
        return this.Sequence(this.FirstOf(this.StringLiteralDouble(), this.StringLiteralSimple(), new Object[]{this.SimpleString()}), this.push(new ConditionValueString(this.removeQuote(this.match()))), new Object[0]);
    }

    Rule SimpleString() {
        return this.OneOrMore(this.FirstOf(this.Escape(), this.Sequence(this.TestNot(this.AnyOf(" #\t\r\n\\,'\"(){}[]")), ANY, new Object[0]), new Object[0])).suppressSubnodes();
    }

    Rule StringLiteralSimple() {
        return this.Sequence("'", this.ZeroOrMore(this.FirstOf(this.EscapeSimple(), this.Sequence(this.TestNot(this.AnyOf("\r\n\\'")), ANY, new Object[0]), new Object[0])).suppressSubnodes(), new Object[]{"'"});
    }

    Rule StringLiteralDouble() {
        return this.Sequence("\"", this.ZeroOrMore(this.FirstOf(this.EscapeDouble(), this.Sequence(this.TestNot(this.AnyOf("\r\n\\\"")), ANY, new Object[0]), new Object[0])).suppressSubnodes(), new Object[]{"\""});
    }

    Rule Escape() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(this.AnyOf("#btnfr'\\''\"\""), this.OctalEscape(), new Object[]{this.UnicodeEscape()}), new Object[0]);
    }

    Rule EscapeSimple() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(this.AnyOf("#btnfr'\\'"), this.OctalEscape(), new Object[]{this.UnicodeEscape()}), new Object[0]);
    }

    Rule EscapeDouble() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(this.AnyOf("#btnfr'\\\""), this.OctalEscape(), new Object[]{this.UnicodeEscape()}), new Object[0]);
    }

    Rule OctalEscape() {
        return this.FirstOf(this.Sequence(this.CharRange('0', '3'), this.CharRange('0', '7'), new Object[]{this.CharRange('0', '7')}), this.Sequence(this.CharRange('0', '7'), this.CharRange('0', '7'), new Object[0]), new Object[]{this.CharRange('0', '7')});
    }

    Rule UnicodeEscape() {
        return this.Sequence(this.OneOrMore(Character.valueOf('u')), this.HexDigit(), new Object[]{this.HexDigit(), this.HexDigit(), this.HexDigit()});
    }

    Rule HexDigit() {
        return this.FirstOf(this.CharRange('a', 'f'), this.CharRange('A', 'F'), new Object[]{this.CharRange('0', '9')});
    }

    Rule space() {
        return this.ZeroOrMore(this.AnyOf(" \t\f"));
    }
}

