/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.sql.Blob;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.matcher.StartsWithTagNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.matcher.TagValueDefinitionMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.DefaultTagValueMetadatasProvider;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.templates.DbNamingStrategy;

@Component(role=TagValueMetadatasProvider.class, hint="topia-hibernate")
public class TopiaHibernateTagValues
extends DefaultTagValueMetadatasProvider {
    private static final String TAG_ATTRIBUTE_TYPE = "attributeType";
    private static final String TAG_HIBERNATE_ATTRIBUTE_TYPE = "hibernateAttributeType";
    protected static final Map<String, String> HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES = Maps.newHashMap();

    public String getDescription() {
        return I18n.t((String)"topia.hibernate.tagvalues", (Object[])new Object[0]);
    }

    public TopiaHibernateTagValues() {
        super((TagValueMetadata[])Store.values());
    }

    public String getPersistenceTypeTagValue(ObjectModelClassifier classifier) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.persistenceType, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier});
    }

    public String getInheritanceStrategyTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.inheritanceStrategy, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage});
    }

    public String getDbNameTagValue(ObjectModelElement element) {
        return TagValueUtil.findDirectTagValue((TagValueMetadata)Store.dbName, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{null, element});
    }

    public DbNamingStrategy getDbNamingStrategyTagValue(WithTagValuesOrStereotypes ... elements) {
        String tagValue = TagValueUtil.findDirectTagValue((TagValueMetadata)Store.dbNamingStrategy, (WithTagValuesOrStereotypes[])elements);
        return DbNamingStrategy.valueOf(tagValue);
    }

    public String getDbSchemaNameTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.dbSchema, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public String getManytoManyTableNameTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findDirectTagValue((TagValueMetadata)Store.manyToManyTableName, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public String getLengthTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.length, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public String getAccessTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.access, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public boolean getNaturalIdTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.naturalId, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public boolean getNaturalIdMutableTagValue(ObjectModelClassifier classifier) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.naturalIdMutable, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier});
    }

    public String getInverseTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.inverse, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public String getLazyTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.lazy, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public String getFetchTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.fetch, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public String getOrderByTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.orderBy, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public Boolean getNotNullTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findNullableBooleanTagValue((TagValueMetadata)Store.notNull, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public String getProxyInterfaceTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.hibernateProxyInterface, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public boolean getSortAttributeTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.sortAttribute, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public boolean isGenerateForeignKeyNames(ObjectModelClassifier classifier, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.generateForeignKeyNames, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, model});
    }

    public String getHibernateAttributeType(ObjectModelAttribute attribute, ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValueUtil.findDirectTagValue((TagValueMetadata)Store.hibernateAttributeType, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{null, attribute});
        if (value == null) {
            String tagValueName = "hibernateAttributeType." + attribute.getType();
            String defaultValue = HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.get(attribute.getType());
            value = TagValueUtil.findTagValue((String)tagValueName, (String)defaultValue, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute, classifier, aPackage, model});
        }
        return value;
    }

    public String getAttributeType(ObjectModelAttribute attribute, ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValueUtil.findDirectTagValue((TagValueMetadata)Store.attributeType, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{null, attribute});
        if (value == null) {
            String tagValueName = "attributeType." + attribute.getType();
            value = TagValueUtil.findTagValue((String)tagValueName, null, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute, classifier, aPackage, model});
        }
        return value;
    }

    public String getSqlTypeTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.sqlType, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public boolean getIndexForeignKeysTagValue(ObjectModelAttribute attribute, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.indexForeignKeys, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute, aPackage, model});
    }

    public boolean hasUseEnumerationNameTagValue(ObjectModelAttribute attr, ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.useEnumerationName, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attr, classifier, aPackage, model});
    }

    @Deprecated
    public String getTypeTagValue(ObjectModelAttribute attribute) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.type, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attribute});
    }

    public String getDeprecatedAttributeTagValueMessage(ObjectModelClass clazz, ObjectModelAttribute attr, String deprecatedTagValue, String newTagValue, String value) {
        String tagValuePrefix = clazz.getQualifiedName() + ".attribute." + attr.getName() + ".tagValue.";
        String deprecatedTagName = tagValuePrefix + deprecatedTagValue + "=" + value;
        String tagName = tagValuePrefix + newTagValue + "=" + value;
        return "\n---------\nYou are using a deprecated tagValue (" + deprecatedTagName + "), replace it by\n" + tagName + "\n---------\n";
    }

    public String getDeprecatedModelTagValueMessage(ObjectModel model, String deprecatedTagValue, String newTagValue, String value) {
        String tagValuePrefix = "model.tagValue.";
        String deprecatedTagName = tagValuePrefix + deprecatedTagValue + "=" + value;
        String tagName = tagValuePrefix + newTagValue + "=" + value;
        return "\n---------\nYou are using a deprecated tagValue (" + deprecatedTagName + "), replace it by\n" + tagName + "\n---------\n";
    }

    static {
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(String.class.getSimpleName(), String.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Boolean.class.getSimpleName(), Boolean.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Byte.class.getSimpleName(), Byte.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Character.class.getSimpleName(), Character.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Short.class.getSimpleName(), Short.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Integer.class.getSimpleName(), Integer.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Long.class.getSimpleName(), Long.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Float.class.getSimpleName(), Float.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Double.class.getSimpleName(), Double.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Blob.class.getSimpleName(), Blob.class.getName().toLowerCase());
    }

    public static enum Store implements TagValueMetadata
    {
        persistenceType(I18n.n((String)"topia.hibernate.tagValue.persistenceType", (Object[])new Object[0]), String.class, null, ObjectModelClassifier.class),
        dbName(I18n.n((String)"topia.hibernate.tagValue.dbName", (Object[])new Object[0]), String.class, null, ObjectModelElement.class),
        dbNamingStrategy(I18n.n((String)"topia.hibernate.tagValue.dbNamingStrategy", (Object[])new Object[0]), String.class, DbNamingStrategy.CAMEL_CASE.name(), new Class[]{ObjectModelElement.class, ObjectModelClassifier.class, ObjectModelPackage.class, ObjectModel.class}),
        reverseDbName(I18n.n((String)"topia.hibernate.tagValue.reverseDbName", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        manyToManyTableName(I18n.n((String)"topia.hibernate.tagValue.manyToManyTableName", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        dbSchema(I18n.n((String)"topia.hibernate.tagValue.dbSchema", (Object[])new Object[0]), String.class, null, new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModelAttribute.class}),
        length(I18n.n((String)"topia.hibernate.tagValue.length", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        access(I18n.n((String)"topia.hibernate.tagValue.access", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        naturalId(I18n.n((String)"topia.hibernate.tagValue.naturalId", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        naturalIdMutable(I18n.n((String)"topia.hibernate.tagValue.naturalIdMutable", (Object[])new Object[0]), Boolean.TYPE, null, ObjectModelClassifier.class),
        inverse(I18n.n((String)"topia.hibernate.tagValue.inverse", (Object[])new Object[0]), Boolean.TYPE, null, ObjectModelAttribute.class),
        lazy(I18n.n((String)"topia.hibernate.tagValue.lazy", (Object[])new Object[0]), Boolean.TYPE, null, ObjectModelAttribute.class),
        fetch(I18n.n((String)"topia.hibernate.tagValue.fetch", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        orderBy(I18n.n((String)"topia.hibernate.tagValue.orderBy", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        notNull(I18n.n((String)"topia.hibernate.tagValue.notNull", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        useEnumerationName(I18n.n((String)"topia.hibernate.tagValue.useEnumerationName", (Object[])new Object[0]), Boolean.TYPE, "true", new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModelAttribute.class}),
        hibernateProxyInterface(I18n.n((String)"topia.hibernate.tagValue.hibernateProxyInterface", (Object[])new Object[0]), String.class, null, new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}),
        inheritanceStrategy(I18n.n((String)"topia.hibernate.tagValue.inheritanceStrategy", (Object[])new Object[0]), String.class, "union-subclass", new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}),
        sortAttribute(I18n.n((String)"topia.hibernate.tagValue.sortAttribute", (Object[])new Object[0]), Boolean.TYPE, "false", new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}),
        type(I18n.n((String)"topia.hibernate.tagValue.type", (Object[])new Object[0]), String.class, null, new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}),
        sqlType(I18n.n((String)"topia.hibernate.tagValue.sqlType", (Object[])new Object[0]), String.class, null, ObjectModelAttribute.class),
        indexForeignKeys(I18n.n((String)"topia.hibernate.tagValue.indexForeignKeys", (Object[])new Object[0]), Boolean.TYPE, "true", new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelAttribute.class}),
        generateForeignKeyNames(I18n.n((String)"topia.hibernate.tagValue.generateForeignKeyNames", (Object[])new Object[0]), Boolean.TYPE, "false", new Class[]{ObjectModel.class, ObjectModelClassifier.class}),
        hibernateAttributeType(I18n.n((String)"topia.hibernate.tagValue.hibernateAttributeType", (Object[])new Object[0]), (Class<?>)String.class, null, (Class<? extends TagValueDefinitionMatcher>)StartsWithTagNameMatcher.class, (Class<?>[])new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModelAttribute.class}),
        attributeType(I18n.n((String)"topia.hibernate.tagValue.attributeType", (Object[])new Object[0]), (Class<?>)String.class, null, (Class<? extends TagValueDefinitionMatcher>)StartsWithTagNameMatcher.class, (Class<?>[])new Class[]{ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModelAttribute.class});

        private final Set<Class<?>> targets;
        private final Class<?> tagValueType;
        private final String i18nDescriptionKey;
        private final String defaultValue;
        private final Class<? extends TagValueDefinitionMatcher> matcher;

        private Store(String i18nDescriptionKey, Class<?> tagValueType, String defaultValue, Class<?> ... targets) {
            this(i18nDescriptionKey, tagValueType, defaultValue, (Class<? extends TagValueDefinitionMatcher>)EqualsTagValueNameMatcher.class, targets);
        }

        private Store(String i18nDescriptionKey, Class<?> tagValueType, String defaultValue, Class<? extends TagValueDefinitionMatcher> matcher, Class<?> ... targets) {
            this.targets = ImmutableSet.copyOf((Object[])targets);
            this.tagValueType = tagValueType;
            this.i18nDescriptionKey = i18nDescriptionKey;
            this.defaultValue = defaultValue;
            this.matcher = matcher;
        }

        public String getName() {
            return this.name();
        }

        public Set<Class<?>> getTargets() {
            return this.targets;
        }

        public Class<?> getType() {
            return this.tagValueType;
        }

        public Class<? extends TagValueDefinitionMatcher> getMatcherClass() {
            return this.matcher;
        }

        public String getDescription() {
            return I18n.t((String)this.i18nDescriptionKey, (Object[])new Object[0]);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDeprecated() {
            return false;
        }
    }
}

