package org.nuiton.topia.test.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class PetAbstract extends TopiaEntityAbstract implements Pet {

    public String name;
    public String type;
    public Person person;
    public Race race;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Pet.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Pet.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "type", String.class, type);
        visitor.visit(this, "person", Person.class, person);
        visitor.visit(this, "race", Race.class, race);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getRace());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setType :
     * @param value 
     */

    public void setType(String value) {
        String _oldValue = this.type;
        fireOnPreWrite("type", _oldValue, value);
        this.type = value;
        fireOnPostWrite("type", _oldValue, value);
}

    /**
     * getType :
     * @return String 
     */

    public String getType() {
        fireOnPreRead("type", type);
        String result = this.type;
        fireOnPostRead("type", type);
        return result;
}

    /**
     * setPerson :
     * @param value 
     */

    public void setPerson(Person value) {
        Person _oldValue = this.person;
        fireOnPreWrite("person", _oldValue, value);
        this.person = value;
        fireOnPostWrite("person", _oldValue, value);
}

    /**
     * getPerson :
     * @return Person 
     */

    public Person getPerson() {
        fireOnPreRead("person", person);
        Person result = this.person;
        fireOnPostRead("person", person);
        return result;
}

    /**
     * setRace :
     * @param value 
     */

    public void setRace(Race value) {
        Race _oldValue = this.race;
        fireOnPreWrite("race", _oldValue, value);
        this.race = value;
        fireOnPostWrite("race", _oldValue, value);
}

    /**
     * getRace :
     * @return Race 
     */

    public Race getRace() {
        fireOnPreRead("race", race);
        Race result = this.race;
        fireOnPostRead("race", race);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("type", this.type).
            append("race", this.race).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.pet");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.type");
    org.nuiton.i18n.I18n.n_("topia.test.common.person");
    org.nuiton.i18n.I18n.n_("topia.test.common.race");
    }

} //PetAbstract
