/*
 * Decompiled with CFR 0.152.
 */
package sdoc.lexers;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import sdoc.lexers.Lexer;
import sdoc.lexers.tokens.Token;
import sdoc.lexers.tokens.TokenFactory;

public class XmlLexer
implements Lexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 128;
    public static final int INTAG = 4;
    public static final int DTD = 3;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 1;
    public static final int CDATA = 5;
    public static final int PI = 2;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0004\u0001\u0002\u0001\u0000\u0001\u0001\u0013\u0000\u0001\u0004\u0001\u000b\u0001\t\u0003\u0000\u0001\u0005\u0001\n\u0005\u0000\u0001\u0013\r\u0000\u0001\u0007\u0001\u0003\u0001\b\u0001\u0012\u0001\u0014\u0001\u0000\u0001\u000f\u0001\u0006\u0001\r\u0001\u000e\u000f\u0006\u0001\u0010\u0006\u0006\u0001\f\u0001\u0000\u0001\u0011\u0003\u0000\u001a\u0006\uff85\u0000";
    private static final char[] ZZ_CMAP = XmlLexer.zzUnpackCMap("\t\u0000\u0001\u0004\u0001\u0002\u0001\u0000\u0001\u0001\u0013\u0000\u0001\u0004\u0001\u000b\u0001\t\u0003\u0000\u0001\u0005\u0001\n\u0005\u0000\u0001\u0013\r\u0000\u0001\u0007\u0001\u0003\u0001\b\u0001\u0012\u0001\u0014\u0001\u0000\u0001\u000f\u0001\u0006\u0001\r\u0001\u000e\u000f\u0006\u0001\u0010\u0006\u0006\u0001\f\u0001\u0000\u0001\u0011\u0003\u0000\u001a\u0006\uff85\u0000");
    private static final int[] ZZ_ACTION = XmlLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0006\u0000\u0002\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0006\u0001\b\u0001\t\u0001\b\u0001\n\u0001\u000b\u0001\f\u0002\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0002\u0012\u0001\u0013\u0001\u0014\u0001\u0005\u0001\u0000\u0001\u0015\u0001\u0016\u0001\u0017\u0003\u0000\u0001\u0018\u0001\u0019\u0001\u0000\u0001\u001a\u0004\u0000\u0001\u001b";
    private static final int[] ZZ_ROWMAP = XmlLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0015\u0000*\u0000?\u0000T\u0000i\u0000~\u0000\u0093\u0000\u00a8\u0000\u00bd\u0000\u00d2\u0000\u00e7\u0000\u00fc\u0000\u00a8\u0000\u0111\u0000\u0126\u0000\u00a8\u0000\u013b\u0000\u0150\u0000\u00a8\u0000\u00a8\u0000\u0165\u0000\u017a\u0000\u00a8\u0000\u018f\u0000\u01a4\u0000\u00a8\u0000\u01b9\u0000\u01ce\u0000\u01e3\u0000\u00a8\u0000\u00a8\u0000\u01f8\u0000\u00a8\u0000\u00a8\u0000\u00a8\u0000\u020d\u0000\u0222\u0000\u0237\u0000\u00a8\u0000\u00a8\u0000\u024c\u0000\u00a8\u0000\u0261\u0000\u0276\u0000\u028b\u0000\u02a0\u0000\u00a8";
    private static final int[] ZZ_TRANS = XmlLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u000f\u0007\u0002\r\u0001\u000e\u0010\r\u0001\u000f\u0001\r\u0002\u0010\u0001\u0011\u0011\u0010\u0001\u0012\u0002\u0013\u0001\u0014\u000f\u0013\u0001\u0015\u0002\u0013\u0001\u0016\u0001\u0017\u0001\u0000\u0001\u0016\u0001\u000b\u0003\u0016\u0001\u0018\u0001\u0019\u0001\u001a\u0007\u0016\u0001\u001b\u0002\u0016\u0011\u001c\u0001\u001d\u0003\u001c\u0002\u0007\u0004\u0000\u0010\u0007\u0001\b\u0002\u0000\u0001\u000b\u0001\u0000\u000f\u0007 \u0000\u0001\u001e\b\u0000\u0001\u001f\u0001\u0000\u0001\u000b\u0002\u0000\u0001\u000b\u0016\u0000\u0001\f\u0001 \u0005\u0000\u0004\f\u0004\u0000\u0002\r\u0001\u0000\u0010\r\u0001\u0000\u0001\r\u0013\u0000\u0001!\u0001\u0000\u0002\u0010\u0001\u0000\u0011\u0010\u0013\u0000\u0001\"\u0002\u0000\u0002\u0013\u0001\u0000\u000f\u0013\u0001\u0000\u0002\u0013\u0002\u0016\u0001\u0000\u0001\u0016\u0001\u0000\u0003\u0016\u0003\u0000\u0007\u0016\u0001\u0000\u0003\u0016\u0001\u0017\u0001\u0000\u0001\u0016\u0001\u000b\u0003\u0016\u0003\u0000\u0007\u0016\u0001\u0000\u0002\u0016\t\u0019\u0001#\u000b\u0019\n\u001a\u0001$\n\u001a\u0011\u001c\u0001\u0000\u0003\u001c\u0011\u0000\u0001%\u000f\u0000\u0001&\u0006\u0000\u0001'\u0013\u0000\u0001(\u0014\u0000\u0001)\u000f\u0000\u0001*\u001a\u0000\u0001+\u000f\u0000\u0001,\u0015\u0000\u0001-\u0015\u0000\u0001.\u0013\u0000\u0001/\u0011\u0000\u00010\b\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = XmlLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0006\u0000\u0002\u0001\u0001\t\u0004\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0001\u0002\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0003\u0001\u0002\t\u0001\u0000\u0003\t\u0003\u0000\u0002\t\u0001\u0000\u0001\t\u0004\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[128];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private List tokens = new ArrayList();
    public static final int INTERNAL_INTAG = -1;
    private int start;

    private static int[] zzUnpackAction() {
        int[] result = new int[48];
        int offset = 0;
        offset = XmlLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[48];
        int offset = 0;
        offset = XmlLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[693];
        int offset = 0;
        offset = XmlLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[48];
        int offset = 0;
        offset = XmlLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public XmlLexer() {
    }

    private void addNullToken() {
        this.tokens.add(TokenFactory.createNullToken());
    }

    @Override
    public int getLastTokenTypeOnLine(Segment text, int initialTokenType) {
        this.getTokens(text, initialTokenType, 0);
        return ((Token)this.tokens.get((int)(this.tokens.size() - 1))).type;
    }

    private void addToken(int type) {
        Token t = TokenFactory.createToken(type, this.yytext());
        if (this.tokens.size() == 1 && ((Token)this.tokens.get((int)0)).type == 0) {
            this.tokens.remove(0);
        }
        this.tokens.add(t);
    }

    @Override
    public List getTokens(Segment text, int initialTokenType, int startOffset) {
        this.tokens.clear();
        int state = 0;
        switch (initialTokenType) {
            case 3: {
                state = 1;
                this.start = text.offset;
                break;
            }
            case 6: {
                state = 3;
                this.start = text.offset;
                break;
            }
            case 21: {
                state = 2;
                this.start = text.offset;
                break;
            }
            case -1: {
                state = 4;
                this.start = text.offset;
                break;
            }
            case 16: {
                state = 5;
                this.start = text.offset;
                break;
            }
            default: {
                state = 0;
            }
        }
        try {
            this.yyreset(new CharArrayReader(text.array, text.offset, text.count));
            this.yybegin(state);
            return this.yylex();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new ArrayList();
        }
    }

    public XmlLexer(Reader in) {
        this.zzReader = in;
    }

    public XmlLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 68) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public List yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block70: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 20: {
                    this.addToken(21);
                    this.yybegin(2);
                }
                case 28: {
                    continue block70;
                }
                case 8: {
                    this.addToken(21);
                }
                case 29: {
                    continue block70;
                }
                case 23: {
                    this.addToken(13);
                }
                case 30: {
                    continue block70;
                }
                case 3: {
                    this.addToken(19);
                    this.yybegin(4);
                }
                case 31: {
                    continue block70;
                }
                case 6: {
                    this.addToken(3);
                }
                case 32: {
                    continue block70;
                }
                case 4: {
                    this.addToken(18);
                }
                case 33: {
                    continue block70;
                }
                case 15: {
                    this.addToken(25);
                }
                case 34: {
                    continue block70;
                }
                case 19: {
                    this.addToken(6);
                    this.yybegin(3);
                }
                case 35: {
                    continue block70;
                }
                case 11: {
                    this.addToken(6);
                    return this.tokens;
                }
                case 36: {
                    continue block70;
                }
                case 12: {
                    this.yybegin(0);
                    this.addToken(6);
                }
                case 37: {
                    continue block70;
                }
                case 24: {
                    this.yybegin(0);
                    this.addToken(3);
                }
                case 38: {
                    continue block70;
                }
                case 13: {
                    this.addToken(5);
                }
                case 39: {
                    continue block70;
                }
                case 18: {
                    this.addToken(16);
                }
                case 40: {
                    continue block70;
                }
                case 1: {
                    this.addToken(17);
                }
                case 41: {
                    continue block70;
                }
                case 9: {
                    this.addToken(21);
                    return this.tokens;
                }
                case 42: {
                    continue block70;
                }
                case 10: {
                    this.addToken(6);
                }
                case 43: {
                    continue block70;
                }
                case 26: {
                    this.addToken(3);
                    this.yybegin(1);
                }
                case 44: {
                    continue block70;
                }
                case 17: {
                    this.yybegin(0);
                    this.addToken(19);
                }
                case 45: {
                    continue block70;
                }
                case 5: {
                    this.addToken(15);
                }
                case 46: {
                    continue block70;
                }
                case 16: {
                    this.addToken(26);
                }
                case 47: {
                    continue block70;
                }
                case 7: {
                    this.addToken(3);
                    return this.tokens;
                }
                case 48: {
                    continue block70;
                }
                case 22: {
                    this.addToken(12);
                }
                case 49: {
                    continue block70;
                }
                case 25: {
                    int temp = this.zzStartRead;
                    this.yybegin(0);
                    this.addToken(16);
                    this.addToken(15);
                }
                case 50: {
                    continue block70;
                }
                case 21: {
                    this.yybegin(0);
                    this.addToken(21);
                }
                case 51: {
                    continue block70;
                }
                case 14: {
                    this.addToken(20);
                }
                case 52: {
                    continue block70;
                }
                case 27: {
                    this.addToken(15);
                    this.yybegin(5);
                }
                case 53: {
                    continue block70;
                }
                case 2: {
                    this.addNullToken();
                    return this.tokens;
                }
                case 54: {
                    continue block70;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 4: {
                        this.addToken(-1);
                        return this.tokens;
                    }
                    case 49: {
                        continue block70;
                    }
                    case 3: {
                        this.addToken(6);
                        return this.tokens;
                    }
                    case 50: {
                        continue block70;
                    }
                    case 0: {
                        this.addNullToken();
                        return this.tokens;
                    }
                    case 51: {
                        continue block70;
                    }
                    case 1: {
                        this.addToken(3);
                        return this.tokens;
                    }
                    case 52: {
                        continue block70;
                    }
                    case 5: {
                        this.addToken(16);
                        return this.tokens;
                    }
                    case 53: {
                        continue block70;
                    }
                    case 2: {
                        this.addToken(21);
                        return this.tokens;
                    }
                    case 54: {
                        continue block70;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

