/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import com.github.rjeschke.txtmark.Processor;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.dom4j.Document;
import org.nuiton.jrst.JRST;
import org.nuiton.jrst.legacy.JRSTReader;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class PreviewAction
extends AbstractScmWebEditorAction
implements ServletRequestAware {
    private static final long serialVersionUID = -2388759298175611718L;
    private static final Log log = LogFactory.getLog(PreviewAction.class);
    protected transient HttpServletRequest request;
    protected String htmlPreview;
    protected String newText;
    protected String format;

    public String getNewText() {
        return this.newText;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }

    public String getHtmlPreview() {
        return this.htmlPreview;
    }

    public void setHtmlPreview(String htmlPreview) {
        this.htmlPreview = htmlPreview;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String execute() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter in preview action");
        }
        this.htmlPreview = "";
        if (this.format.equals("rst")) {
            try {
                JRSTReader jrst = new JRSTReader();
                Document doc = jrst.read((Reader)new StringReader(this.newText));
                Document generatedDoc = JRST.generateXml((Document)doc, (String)"html");
                this.htmlPreview = generatedDoc.asXML();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"RST generate");
                }
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"RST generate fail", (Throwable)eee);
                }
                this.htmlPreview = "<h4>Parsing error, please read RST specification<h4>";
            }
        } else if (this.format.equals("md")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Markdown generate");
            }
            this.htmlPreview = Processor.process((String)this.newText);
        }
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

