/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.BlowfishCipherService;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.dom4j.Document;
import org.nuiton.jrst.JRST;
import org.nuiton.jrst.legacy.JRSTReader;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.dto.CommitDto;
import org.nuiton.scmwebeditor.api.dto.result.CommitResultDto;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class ScmWebEditorCommitAction
extends AbstractScmWebEditorAction
implements ServletRequestAware,
ServletResponseAware {
    public static final String FILE_MODIFY = "fileModify";
    private static final long serialVersionUID = 6374273568146287730L;
    private static final Log log = LogFactory.getLog(ScmWebEditorCommitAction.class);
    protected String newText;
    protected String commitMessage;
    protected String origText;
    protected String username;
    protected String pw;
    protected String address;
    protected String lastText;
    protected String format;
    protected String projectUrl;
    protected String diff;
    protected String headCommiter;
    protected String mimeType;
    protected boolean force;
    protected boolean saveCookie;
    protected boolean badLogin;
    protected String numRevision;
    protected boolean commitOnly;
    protected transient HttpServletRequest request;
    protected transient HttpServletResponse response;

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getNewText() {
        return this.newText;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getOrigText() {
        return this.origText;
    }

    public void setOrigText(String origText) {
        this.origText = origText;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLastText() {
        return this.lastText;
    }

    public void setLastText(String lastText) {
        this.lastText = lastText;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public String getNumRevision() {
        return this.numRevision;
    }

    public void setNumRevision(String numRevision) {
        this.numRevision = numRevision;
    }

    public String getDiff() {
        return this.diff;
    }

    public void setDiff(String diff) {
        this.diff = diff;
    }

    public String getHeadCommiter() {
        return this.headCommiter;
    }

    public void setHeadCommiter(String headCommiter) {
        this.headCommiter = headCommiter;
    }

    public boolean isSaveCookie() {
        return this.saveCookie;
    }

    public void setSaveCookie(boolean saveCookie) {
        this.saveCookie = saveCookie;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getParameterAddress() {
        return "address";
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    public void setBadLogin(boolean badLogin) {
        this.badLogin = badLogin;
    }

    public boolean isCommitOnly() {
        return this.commitOnly;
    }

    public void setCommitOnly(boolean commitOnly) {
        this.commitOnly = commitOnly;
    }

    protected boolean isRstValid(String rstContent) {
        try {
            JRSTReader jrst = new JRSTReader();
            Document doc = jrst.read((Reader)new StringReader(rstContent));
            Document generatedDoc = JRST.generateXml((Document)doc, (String)"html");
            generatedDoc.asXML();
            if (log.isDebugEnabled()) {
                log.debug((Object)"RST generate success");
            }
            return true;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"RST generate fail", (Throwable)e);
            }
            return false;
        }
    }

    public String execute() {
        System.setProperty("file.encoding", "UTF-8");
        if (!this.force && this.format.equals("rst") && !this.isRstValid(this.newText)) {
            return "errorRst";
        }
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        String repositoryUUID = scmConn.getRepositoryId();
        if (repositoryUUID == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        String usernamepwCookie = null;
        BlowfishCipherService bf = new BlowfishCipherService();
        byte[] privateKey = Base64.decode((String)ScmWebEditorConfig.getKey());
        for (Cookie c : this.request.getCookies()) {
            if (!c.getName().equals(repositoryUUID)) continue;
            usernamepwCookie = c.getValue();
        }
        if (usernamepwCookie != null) {
            String[] resCookie;
            String usernameDecode;
            block20: {
                usernameDecode = null;
                try {
                    usernameDecode = new String(bf.decrypt(Base64.decode(usernamepwCookie), privateKey).getBytes(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (!log.isErrorEnabled()) break block20;
                    log.error((Object)"Can not create a String with UTF-8 encoding");
                }
            }
            if (usernameDecode != null && (resCookie = usernameDecode.split(",")).length == 2) {
                this.username = resCookie[0];
                this.pw = resCookie[1];
            }
        }
        if (this.saveCookie && this.username != null && this.pw != null) {
            Cookie authCookie;
            block21: {
                authCookie = null;
                try {
                    authCookie = new Cookie(repositoryUUID, bf.encrypt((this.username + "," + this.pw).getBytes("UTF-8"), privateKey).toBase64());
                }
                catch (UnsupportedEncodingException e) {
                    if (!log.isErrorEnabled()) break block21;
                    log.error((Object)"Can not get bytes from UTF-8 encoding");
                }
            }
            if (authCookie != null) {
                authCookie.setMaxAge(31536000);
                this.response.addCookie(authCookie);
            }
        }
        String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
        this.username = usernamePw[0];
        this.pw = usernamePw[1];
        CommitDto dto = new CommitDto();
        dto.setUsername(this.username);
        dto.setPassword(this.pw);
        dto.setNewText(this.newText);
        dto.setCommitMessage(this.commitMessage);
        dto.setForce(this.force);
        dto.setAddress(this.address);
        dto.setCommitOnly(this.commitOnly);
        CommitResultDto resultDto = scmConn.commit(dto);
        if (resultDto.getLastText() != null) {
            this.lastText = resultDto.getLastText();
        }
        if (resultDto.getOrigText() != null) {
            this.origText = resultDto.getOrigText();
        }
        if (resultDto.getDiff() != null) {
            this.diff = resultDto.getDiff();
        }
        if (resultDto.getDiff() != null) {
            this.headCommiter = resultDto.getHeadCommiter();
        }
        if (resultDto.getNumRevision() != null) {
            this.numRevision = resultDto.getNumRevision();
        }
        if (resultDto.getError() != null) {
            String error = resultDto.getError();
            if (error.equals("error path")) {
                return "errorPath";
            }
            if (error.equals("auth error")) {
                this.request.setAttribute(this.getParameterAddress(), (Object)this.address);
                this.getScmSession().delScmUser(scmConn.getRepositoryId());
                this.username = null;
                this.pw = null;
                return "login";
            }
            if (error.equals("file modify")) {
                return FILE_MODIFY;
            }
            return "error";
        }
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }
}

