/* *##% Graphical Widget
 * Copyright (C) 2004 - 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.widget;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

import javax.swing.JTextField;

public class DatePicker extends JTextField {

    private static final long serialVersionUID = 1L;
    
    protected DateFormat dateFormat = null;

    public DatePicker(DateFormat dateFormat) {
        super();
        this.dateFormat = dateFormat;
    }

    public void setDate(Date date) {
        super.setText(dateFormat.format(date));
    }

    public Date getDate() throws InvalidDateException {
        Date date = null;
        try {
            date = dateFormat.parse(super.getText());
        } catch (ParseException e) {
            throw new InvalidDateException(e);
        }
        return date;
    }

}
