/* *##% Graphical Widget
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.widget.editor;

import java.io.File;

import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;

/**
 * EditorInterface.
 * 
 * @author poussin
 * 
 * Created: 6 août 2006 12:54:19
 *
 * @author poussin
 * @version $Revision: 233 $
 *
 * Last update: $Date: 2009-12-02 18:00:27 +0100 (mer., 02 déc. 2009) $
 * by : $Author: echatellier $
 */
public interface EditorInterface {

    /**
     * Add document listener.
     * 
     * @param listener listener
     */
    public void addDocumentListener(DocumentListener listener);

    /**
     * Remove document listener.
     * 
     * @param listener listener
     */
    public void removeDocumentListener(DocumentListener listener);

    /**
     * Add caret listener.
     * 
     * @param listener listener
     */
    public void addCaretListener(CaretListener listener);

    /**
     * Remove caret listener.
     * 
     * @param listener listener
     */
    public void removeCaretListener(CaretListener listener);
    
    /**
     * If return true, this editor support this file type.
     * Default implementation return {@code true}.
     * 
     * @param file file to test
     * @return if return {@code true}, this editor support this file type.
     */
    public boolean accept(File file);

    /**
     * Indicate if current opened file has been modified.
     * 
     * @return {@code true} if current file is modified
     */
    public boolean isModified();

    /**
     * Replace the current edited file by file passed in argument.
     * 
     * @param file the file to open
     * @return true if file has been opened
     */
    public boolean open(File file);

    /**
     * Replace the current edited file by file passed in argument.
     * 
     * @param file the file to open
     * @return true if file has been saved and reopen with new name
     */
    public boolean saveAs(File file);

    /**
     * Return the current content text of the editor as {@link String}.
     * 
     * @return return the current content text of the editor as {@link String}
     */
    public String getText();

    /**
     * Set all text with text in argument.
     * 
     * @param text test to set
     */
    public void setText(String text);
    
    /**
     * Cut current editor selection into system clipboard.
     */
    public void cut();
    
    /**
     * Copy current current selection into system clipboard.
     */
    public void copy();
    
    /**
     * Paste current clicboard content into editor at caret position.
     */
    public void paste();
    
    /**
     * Enable/disable editor.
     * 
     * @param b enable
     */
    public void setEnabled(boolean b);
}
