/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: TestUtil.java 1991 2010-12-29 17:54:25Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.5.3/src/main/java/org/nuiton/util/TestUtil.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util;

import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;

import java.io.File;
import java.io.IOException;

/**
 *  TODO tchemit 2010-08-25 : Why a Test thing is here ? Move it to the test and expose nuiton-utils with a test classifier.
 *
 * This class contains useful methods for Tests.
 *
 * Created: 22 juin 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @deprecated since 1.5.3, will not be replaced here and will be removed in 2.0
 */
@Deprecated
public class TestUtil {

    private static Log log = LogFactory.getLog(TestUtil.class);

    public static final String TESTS_DATA_DEFAULT_DIR = "surefire-data";

    /**
     * Create a directory in target directory for maven projects. The
     * directory name will be the default one defined by {@link #TESTS_DATA_DEFAULT_DIR}
     *
     * @return the directory created
     * @see #createTestsDataDirectory(String)
     */
    public static File createDefaultTestsDataDirectory() {
        return createTestsDataDirectory(TESTS_DATA_DEFAULT_DIR);
    }

    /**
     * Create a directory in target directory for maven projects. The
     * directory will be called {@code dirName}. This directory will be useful
     * to put all data created during tests. 
     *
     * @param dirName name of the directory to create
     * @return the directory created
     */
    public static File createTestsDataDirectory(String dirName) {
        // Search basedir from maven environment
        String basedirPath = System.getenv("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }

        File result = new File(basedirPath, "target" + File.separator + dirName);

        try {
            FileUtil.createDirectoryIfNecessary(result);
        } catch (IOException eee) {
            String errorMessage = "Error during tests data directory creation";
            if (log.isErrorEnabled()) {
                log.error(errorMessage, eee);
            }
            throw new Error(errorMessage, eee);
        }

        if (log.isDebugEnabled()) {
            log.debug("Create tests data directory : " + result.getAbsolutePath());
        }

        return result;
    }

    public static File getBaseDir() {
        // Search basedir from maven environment
        String basedirPath = System.getenv("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }

        File result = new File(basedirPath);
        return result;
    }
}
