/* **##% Nuiton utilities library
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
 * Log4JWrapper.java
 *
 * Created: 10 janv. 07 17:07:54
 *
 * @author poussin
 * @version $Revision: 1637 $
 *
 * Last update: $Date: 2009-06-21 04:53:31 +0200 (dim., 21 juin 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.log;

import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;


/**
 * Cette classe n'est utile que parce qu'on ne peut pas modifier le FQCN present
 * dans {@link Log4JLogger}. Donc sans cette classe on n'a pas le bon nom
 * de classe.method et numero de ligne dans la sortie du log.
 * 
 * @author poussin
 */
public class Log4JWrapper {
    
    private static Level traceLevel;

    static {
        // Releases of log4j1.2 >= 1.2.12 have Priority.TRACE available, earlier
        // versions do not. If TRACE is not available, then we have to map
        // calls to Log.trace(...) onto the DEBUG level.
        
        try {
            traceLevel = (Level)Level.class.getDeclaredField("TRACE").get(null);
        } catch(Exception ex) {
            // ok, trace not available
            traceLevel = Level.DEBUG;
        }
    }

    
    final static private String FQCN = LutinLog.class.getName() + ".";    

    static public void fatal(Log4JLogger log, Object msg, Throwable eee) {
        log.getLogger().log(FQCN, Level.FATAL, msg, eee);
    }
    static public void error(Log4JLogger log, Object msg, Throwable eee) {
        log.getLogger().log(FQCN, Level.ERROR, msg, eee);
    }
    static public void warn(Log4JLogger log, Object msg, Throwable eee) {
        log.getLogger().log(FQCN, Level.WARN, msg, eee);
    }
    static public void info(Log4JLogger log, Object msg, Throwable eee) {
        log.getLogger().log(FQCN, Level.INFO, msg, eee);
    }
    static public void debug(Log4JLogger log, Object msg, Throwable eee) {
        log.getLogger().log(FQCN, Level.DEBUG, msg, eee);
    }
    static public void trace(Log4JLogger log, Object msg, Throwable eee) {
        log.getLogger().log(FQCN, traceLevel, msg, eee);
    }
}


