/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.annotation.After;
import org.codehaus.aspectwerkz.annotation.AfterThrowing;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

@Aspect(value="perJVM")
public class LutinTrace {
    private static Log log = LogFactory.getLog(LutinTrace.class);
    private static List<LutinTrace> instances = new ArrayList<LutinTrace>();
    public static final int STAT_CALL = 0;
    public static final int STAT_CALL_NEST_METHOD = 1;
    public static final int STAT_TIME_MIN = 2;
    public static final int STAT_TIME_MAX = 3;
    public static final int STAT_TIME_TOTAL = 4;
    public static final int STAT_TIME_TOTAL_NEST_METHOD = 5;
    private static final int STACK_CALL_NEST_METHOD = 0;
    private static final int STACK_TIME_START = 1;
    private static final int STACK_TIME_START_NEST_METHOD = 2;
    protected Map<Method, long[]> statistiques = new LinkedHashMap<Method, long[]>();
    protected Stack<long[]> callStack = new Stack();

    public LutinTrace() {
        instances.add(this);
    }

    public long[] getStatistiques(Method method) {
        long[] result = this.statistiques.get(method);
        if (result == null) {
            result = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            this.statistiques.put(method, result);
        }
        return result;
    }

    @Before(value="executeMethod")
    public void traceBeforeExecute(JoinPoint jp) {
        long current = System.nanoTime();
        long[] stackItem = new long[]{0L, current, current};
        this.callStack.push(stackItem);
    }

    @AfterThrowing(value="executeMethod")
    public void traceAfterThrowingExecute(JoinPoint jp) {
        this.traceAfterExecute(jp);
    }

    @After(value="executeMethod")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        long current = System.nanoTime();
        if (this.callStack.isEmpty()) {
            log.warn((Object)("Empty stack in afterExecute for method " + method.getName()));
        } else {
            long[] stackItem = this.callStack.pop();
            long timeSpent = current - stackItem[1];
            long timeSpentNestMethod = current - stackItem[2];
            long[] stat = this.getStatistiques(method);
            stat[0] = stat[0] + 1L;
            stat[1] = stat[1] + stackItem[0];
            stat[4] = stat[4] + timeSpent;
            stat[5] = stat[5] + timeSpentNestMethod;
            if (stat[2] > timeSpent) {
                stat[2] = timeSpent;
            }
            if (stat[3] < timeSpent) {
                stat[3] = timeSpent;
            }
            if (!this.callStack.isEmpty()) {
                long[] parent = this.callStack.peek();
                parent[0] = parent[0] + 1L;
                parent[1] = parent[1] + timeSpentNestMethod;
            }
        }
    }

    public static String getStatistiqueAndClear() {
        StringBuffer result = new StringBuffer();
        for (LutinTrace trace : instances) {
            result.append("--- Statistiques ---\n");
            for (Method method : trace.statistiques.keySet()) {
                long[] stat = trace.getStatistiques(method);
                long meanTime = stat[4] / stat[0];
                result.append(method + "\t" + " call: " + stat[0] + " min: " + DurationFormatUtils.formatDuration((long)(stat[2] / 1000000L), (String)"s'.'S") + " mean: " + DurationFormatUtils.formatDuration((long)(meanTime / 1000000L), (String)"s'.'S") + " max: " + DurationFormatUtils.formatDuration((long)(stat[3] / 1000000L), (String)"s'.'S") + " total: " + DurationFormatUtils.formatDuration((long)(stat[4] / 1000000L), (String)"s'.'S") + " call_nest: " + stat[1] + " total_with_nest: " + DurationFormatUtils.formatDuration((long)(stat[5] / 1000000L), (String)"s'.'S") + "\n");
            }
            result.append("--------------------\n");
        }
        instances.clear();
        return result.toString();
    }

    public static void printStatistiqueAndClear() {
        String stat = LutinTrace.getStatistiqueAndClear();
        if (stat != null && !"".equals(stat)) {
            System.out.println(stat);
        }
    }
}

