/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.init;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.format.I18nMessageFormatter;
import org.nuiton.i18n.init.DefaultI18nInitializer;

public class UserI18nInitializer
extends DefaultI18nInitializer {
    private static final Log log = LogFactory.getLog(UserI18nInitializer.class);
    protected final File userDirectory;
    protected final DefaultI18nInitializer delegate;

    public UserI18nInitializer(File userDirectory, DefaultI18nInitializer delegate) throws NullPointerException {
        this(null, userDirectory, delegate);
    }

    public UserI18nInitializer(String i18nPath, File userDirectory, DefaultI18nInitializer delegate) throws NullPointerException {
        super(delegate == null ? null : delegate.getBundleName(), null, i18nPath == null ? "" : i18nPath);
        if (userDirectory == null) {
            throw new NullPointerException("parameter 'userDirectory' can not be null");
        }
        if (delegate == null) {
            throw new NullPointerException("parameter 'delegate' can not be null");
        }
        this.userDirectory = userDirectory;
        this.delegate = delegate;
    }

    public File getUserDirectory() {
        return this.userDirectory;
    }

    public DefaultI18nInitializer getDelegate() {
        return this.delegate;
    }

    @Override
    public Charset getEncoding() {
        return this.getDelegate().getEncoding();
    }

    @Override
    public void setEncoding(Charset encoding) {
        this.getDelegate().setEncoding(encoding);
    }

    @Override
    public I18nMessageFormatter getMessageFormatter() {
        return this.getDelegate().getMessageFormatter();
    }

    @Override
    public void setMessageFormatter(I18nMessageFormatter messageFormatter) {
        this.getDelegate().setMessageFormatter(messageFormatter);
    }

    @Override
    public I18nBundle[] resolvBundles() throws Exception {
        File directory = this.getUserDirectory();
        boolean isNew = !directory.exists();
        this.createUserI18nLayout(directory);
        this.setLoader(new URLClassLoader(new URL[]{directory.toURI().toURL()}));
        I18nBundle[] bundles = super.resolvBundles();
        if (!isNew) {
            this.updateUserI18nLayout(directory, bundles);
        }
        return bundles;
    }

    protected void createUserI18nLayout(File directory) throws Exception {
        I18nBundleEntry[] entries;
        boolean b;
        boolean bl = b = directory.exists() || directory.mkdirs();
        if (!b) {
            throw new IOException("could not create directory " + directory);
        }
        Properties definition = new Properties();
        String prefixURL = this.getDelegate().resolvDefinition(definition);
        String filename = String.format("%1$s-definition.properties", this.getBundleName());
        File f = new File(directory, filename);
        if (!f.exists()) {
            try (FileOutputStream outStream = new FileOutputStream(f);){
                definition.store(outStream, "Generated by " + this.getClass().getName());
            }
        }
        URL[] urls = this.resolvURLs(prefixURL, definition);
        I18nBundle[] bundles = this.resolvBundles(urls);
        for (I18nBundleEntry e : entries = I18nBundleUtil.getBundleEntries(bundles)) {
            String path;
            String name;
            File dst;
            URL url = e.getPath();
            if (log.isInfoEnabled()) {
                log.info((Object)("I18n file to load : " + url));
            }
            if ((dst = new File(directory, name = (path = url.getPath()).substring(path.lastIndexOf("/")))).exists()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Keep user file " + dst));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Create user file to create : " + dst));
            }
            try (FileOutputStream outStream = new FileOutputStream(dst);
                 InputStream inStream = url.openStream();){
                IOUtils.copy((InputStream)inStream, (OutputStream)outStream);
            }
        }
    }

    public void updateUserI18nLayout(File directory, I18nBundle[] bundles) {
    }
}

