/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin.repository;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.nuiton.license.plugin.repository.LicenseRepository;

public class LicenseDefinition {
    public static final String LICENSE_HEADER_FILE = "header.txt";
    public static final String LICENSE_CONTENT_FILE = "license.txt";
    protected URL baseURL;
    protected String name;
    protected String description;

    public LicenseDefinition(URL baseURL, String name, String description) {
        this.baseURL = baseURL;
        this.name = name;
        this.description = description;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public URL getLicenseURL() throws IOException {
        return LicenseRepository.getUrl(this.baseURL, LICENSE_CONTENT_FILE);
    }

    public URL getHeaderURL() throws IOException {
        return LicenseRepository.getUrl(this.baseURL, LICENSE_HEADER_FILE);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        builder.append("name", (Object)this.name);
        builder.append("description", (Object)this.description);
        builder.append("baseURL", (Object)this.baseURL);
        return builder.toString();
    }
}

