/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.repository.License;
import org.nuiton.license.plugin.repository.LicenseDefinition;
import org.nuiton.license.plugin.repository.LicenseRepository;
import org.nuiton.license.plugin.repository.LicenseRepositoryFactory;

public class LicenseListMojo
extends AbstractMojo {
    protected String extraResolver;
    protected String encoding;
    protected boolean detail;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LicenseRepository factory;
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n\n-------------------------------------------------------------------------------\n");
        buffer.append("                           maven-license-plugin\n");
        buffer.append("-------------------------------------------------------------------------------\n\n");
        buffer.append("Available licenses :\n\n");
        try {
            factory = LicenseRepositoryFactory.newLicenseRepository(true, true, this.extraResolver);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("could not obtain the license repository", (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not obtain the license repository", (Exception)ex);
        }
        for (LicenseDefinition entry : factory.getDefinitions()) {
            String licenseName = entry.getName();
            buffer.append(" * ").append(licenseName).append(" : ").append(entry.getDescription()).append('\n');
            if (!this.detail) continue;
            try {
                License license = factory.getLicense(licenseName);
                buffer.append("\n").append(license.getHeaderContent(this.encoding)).append("\n\n");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not instanciate license with name " + licenseName + " for reason " + ex.getMessage(), (Exception)ex);
            }
        }
        this.getLog().info((CharSequence)buffer.toString());
    }
}

