/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.nuiton:maven-license-plugin:1.0.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Plugin maven de changement de license", 0);
        this.append(sb, "Plugin pour switcher de license dans un module maven 2", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "license:help", 0);
            this.append(sb, "Display help information on maven-license-plugin.\nCall\n\u00a0\u00a0mvn\u00a0license:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "java-update-header".equals(this.goal)) {
            this.append(sb, "license:java-update-header", 0);
            this.append(sb, "Le goal pour switcher les licenses de tous les sources java d'un module maven.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compileSourceRoots (Default: ${project.compileSourceRoots})", 2);
                this.append(sb, "Repertoires des fichiers sources a traiter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraIncludes", 2);
                this.append(sb, "Pour ajouter d'autres fichiers a traiter (separer par des virgules). Exemple : **\\\\/*.css,**\\\\/*.properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResolver", 2);
                this.append(sb, "Un resolver externe", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Un flag pour forcer la generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inceptionYear (Default: ${project.inceptionYear})", 2);
                this.append(sb, "l'annee de creation du module (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "Un flag pour conserver un backup des fichiers modifies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Le type de license a appliquer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "organizationName (Default: ${project.organization.name})", 2);
                this.append(sb, "le nom de l'organisation (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Repertoire de sortie des classes (classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "Dependance du projet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectName (Default: ${project.name})", 2);
                this.append(sb, "le nom du projet (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCompileSourceRoots (Default: ${project.testCompileSourceRoots})", 2);
                this.append(sb, "Repertoires des fichiers sources de test a traiter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testOutputDirectory (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "Repertoire du build des tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jaxx-update-header".equals(this.goal)) {
            this.append(sb, "license:jaxx-update-header", 0);
            this.append(sb, "Le goal pour switcher les licenses de tous les sources jaxx d'un module maven.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compileSourceRoots (Default: ${project.compileSourceRoots})", 2);
                this.append(sb, "Repertoires des fichiers sources a traiter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraIncludes", 2);
                this.append(sb, "Pour ajouter d'autres fichiers a traiter (separer par des virgules). Exemple : **\\\\/*.css,**\\\\/*.properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResolver", 2);
                this.append(sb, "Un resolver externe", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Un flag pour forcer la generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inceptionYear (Default: ${project.inceptionYear})", 2);
                this.append(sb, "l'annee de creation du module (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "Un flag pour conserver un backup des fichiers modifies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Le type de license a appliquer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "organizationName (Default: ${project.organization.name})", 2);
                this.append(sb, "le nom de l'organisation (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Repertoire de sortie des classes (classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "Dependance du projet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectName (Default: ${project.name})", 2);
                this.append(sb, "le nom du projet (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCompileSourceRoots (Default: ${project.testCompileSourceRoots})", 2);
                this.append(sb, "Repertoires des fichiers sources de test a traiter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testOutputDirectory (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "Repertoire du build des tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

