/**
 * *##% Plugin maven de changement de license
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.util.Map;
import org.nuiton.processor.filters.LicenseFilter;
import org.nuiton.util.FileUpdaterHelper;
import org.nuiton.util.MirroredFileUpdater;

/**
 * Le goal pour switcher les licenses de tous les sources jaxx d'un module
 * maven.
 *
 * @author chemit
 * @goal jaxx-update-header
 * @phase process-sources
 * @requiresProject true
 * 
 * @since 1.0.0
 */
public class JaxxUpdateHeaderPlugin extends AbstractUpdateHeaderPlugin {

    @Override
    protected Map<File, String[]> getFilesToTreate() {

        Map<File, String[]> files = new java.util.HashMap<File, String[]>();

        MirroredFileUpdater updater = null;
        if (!force) {
            updater = FileUpdaterHelper.newJavaFileUpdater();
            updater.setDestinationDirectory(outputDirectory);
        }
        getFilesToTreateForRoots(new String[]{"**\\/*.jaxx"}, null, compileSourceRoots, files, updater);
        if (!force) {
            updater.setDestinationDirectory(testOutputDirectory);
        }
        getFilesToTreateForRoots(new String[]{"**\\/*.jaxx"}, null, testCompileSourceRoots, files, updater);
        getExtraFilesToTreate(files);
        return files;
    }

    @Override
    protected HeaderGenerator newHeaderGenerator() {
        return new HeaderGenerator() {

            @Override
            public String getHeader(String licenseHeaderContent) {
                return "<!--\n\n/**\n * " + LicenseFilter.HEADER + " " + licenseHeaderContent + " " + LicenseFilter.FOOTER + "\n */\n\n-->\n";
            }
        };
    }
}
