/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.RedmineAnonymousService;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.RedmineServiceLoginException;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class DefaultRedmineAnonymousService
implements RedmineServiceImplementor,
RedmineAnonymousService {
    private static final Log log = LogFactory.getLog(DefaultRedmineAnonymousService.class);
    protected RedmineServiceImplementor delegateImplementor;

    @Override
    public IssueStatus[] getIssueStatuses() throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_ISSUE_STATUS_LIST, IssueStatus.class, new Object[0]);
    }

    @Override
    public IssuePriority[] getIssuePriorities() throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_ISSUE_PRIORITY_LIST, IssuePriority.class, new Object[0]);
    }

    @Override
    public Project[] getProjects() throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_PROJECT_LIST, Project.class, new Object[0]);
    }

    @Override
    public IssueCategory[] getIssueCategories(String projectName) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_ISSUE_CATEGORY_LIST, IssueCategory.class, projectName);
    }

    @Override
    public Project getProject(String projectName) throws RedmineServiceException {
        return this.getData(RedmineRestClient.GET_PROJECT, Project.class, projectName);
    }

    @Override
    public Tracker[] getTrackers(String projectName) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_TRACKER_LIST, Tracker.class, projectName);
    }

    @Override
    public News[] getNews(String projectName) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_NEWS_LIST, News.class, projectName);
    }

    @Override
    public User[] getProjectMembers(String projectName) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_USER_LIST, User.class, projectName);
    }

    @Override
    public Version[] getVersions(String projectName) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_VERSION_LIST, Version.class, projectName);
    }

    @Override
    public Version getVersion(String projectName, String versionName) throws RedmineServiceException {
        return this.getData(RedmineRestClient.GET_VERSION, Version.class, projectName, versionName);
    }

    @Override
    public Attachment[] getAttachments(String projectName, String versionName) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_ATTACHMENTS_LIST, Attachment.class, projectName, versionName);
    }

    @Override
    public Issue[] getIssues(String projectName, String versionName) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_ISSUE_LIST, Issue.class, projectName, versionName);
    }

    @Override
    public TimeEntry[] getIssueTimeEntries(String projectName, String issueId) throws RedmineServiceException {
        return this.getDatas(RedmineRestClient.GET_ISSUE_TIME_ENTRY_LIST, TimeEntry.class, projectName, issueId);
    }

    @Override
    public Issue[] getIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.getDatas(RedmineRestClient.GET_PROJECT_ISSUES, Issue.class, projectName);
        return result;
    }

    @Override
    public Issue[] getOpenedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.getDatas(RedmineRestClient.GET_PROJECT_OPENED_ISSUES, Issue.class, projectName);
        return result;
    }

    @Override
    public Issue[] getClosedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = this.getDatas(RedmineRestClient.GET_PROJECT_CLOSED_ISSUES, Issue.class, projectName);
        return result;
    }

    @Override
    public RedmineServiceImplementor init(RestClientConfiguration configuration) throws RedmineServiceException {
        configuration.setAnonymous(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init configuration for " + this));
        }
        RedmineServiceImplementor result = this.delegateImplementor.init(configuration);
        return result;
    }

    @Override
    public RedmineServiceImplementor init(RestClient session) throws RedmineServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init session for " + this));
        }
        this.checkNotLoggued(session);
        return this.delegateImplementor.init(session);
    }

    @Override
    public <T> T getData(String requestName, Class<T> type, Object ... args) throws RedmineServiceException {
        return this.delegateImplementor.getData(requestName, type, args);
    }

    @Override
    public <T> T[] getDatas(String requestName, Class<T> type, Object ... args) throws RedmineServiceException {
        return this.delegateImplementor.getDatas(requestName, type, args);
    }

    @Override
    public <T> T sendData(String requestName, Class<T> klazz, Object ... args) throws RedmineServiceException {
        return this.delegateImplementor.sendData(requestName, klazz, args);
    }

    @Override
    public <T> T[] sendDatas(String requestName, Class<T> klazz, Object ... args) throws RedmineServiceException {
        return this.delegateImplementor.sendDatas(requestName, klazz, args);
    }

    @Override
    public boolean isInit() {
        return this.delegateImplementor.isInit();
    }

    @Override
    public void destroy() throws RedmineServiceException {
        this.delegateImplementor.destroy();
    }

    @Override
    public void checkNotLoggued(RestClient session) throws IllegalStateException, RedmineServiceLoginException, NullPointerException {
        this.delegateImplementor.checkNotLoggued(session);
    }

    @Override
    public void checkLoggued() throws IllegalStateException, RedmineServiceLoginException, NullPointerException {
        this.delegateImplementor.checkLoggued();
    }
}

