/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.model.io.xpp3;

import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.IOUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.jredmine.TestHelper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.RedmineModelEnum;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.io.xpp3.RedmineXpp3Helper;

public class RedmineXpp3HelperTest {
    protected static final Log log = LogFactory.getLog(RedmineXpp3HelperTest.class);
    private static final RedmineModelEnum[] TYPE_ORDER = new RedmineModelEnum[]{RedmineModelEnum.attachment, RedmineModelEnum.issue, RedmineModelEnum.project, RedmineModelEnum.tracker, RedmineModelEnum.user, RedmineModelEnum.version, RedmineModelEnum.issueStatus, RedmineModelEnum.issuePriority, RedmineModelEnum.issueCategory, RedmineModelEnum.news, RedmineModelEnum.timeEntry};
    protected static File testDir;
    protected static RedmineXpp3Helper builder;
    File file;
    protected boolean verbose;
    protected static int universeSize;

    @BeforeClass
    public static void setUpClass() throws Exception {
        testDir = TestHelper.getTestDir(RedmineXpp3HelperTest.class.getPackage().getName(), "target" + File.separator + "test-classes");
        builder = new RedmineXpp3Helper();
        log.info((Object)("test dir : " + TestHelper.getRelativePath(TestHelper.getBasedir(), testDir)));
        TestHelper.loadMemoryModel();
        universeSize = TYPE_ORDER.length;
        if (universeSize < RedmineModelEnum.values().length) {
            log.warn((Object)"There is some types of the model which are not tested :");
            Set<RedmineModelEnum> keySet = TestHelper.getMemoryModel().keySet();
            for (RedmineModelEnum t : RedmineModelEnum.values()) {
                if (keySet.contains(t)) continue;
                log.warn((Object)t);
            }
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        testDir = null;
        builder = null;
    }

    @Before
    public void setUp() {
        this.verbose = TestHelper.isVerbose();
    }

    @After
    public void tearDown() {
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRead() throws Exception {
        TestAction action = new TestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected <T> void runForType(File rootDir, Class<T> type, List<?> expected) throws Exception {
                File file = new File(rootDir, Introspector.decapitalize(type.getSimpleName()) + ".xml");
                if (RedmineXpp3HelperTest.this.verbose) {
                    log.info((Object)("will test " + TestHelper.getRelativePath(TestHelper.getBasedir(), file)));
                }
                Object actual = builder.readObject(type, file, true);
                TestHelper.assertMyEquals(type, expected.get(0), actual);
                FileInputStream input = new FileInputStream(file);
                try {
                    String txt = IOUtil.toString((InputStream)input);
                    actual = builder.readObject(type, txt, true);
                    TestHelper.assertMyEquals(type, expected.get(0), actual);
                }
                finally {
                    input.close();
                }
            }
        };
        action.run("single", Arrays.asList(TestHelper.getModel(Attachment.class).get(0)), Arrays.asList(TestHelper.getModel(Issue.class).get(0)), Arrays.asList(TestHelper.getModel(Project.class).get(0)), Arrays.asList(TestHelper.getModel(Tracker.class).get(0)), Arrays.asList(TestHelper.getModel(User.class).get(0)), Arrays.asList(TestHelper.getModel(Version.class).get(0)), Arrays.asList(TestHelper.getModel(IssueStatus.class).get(0)), Arrays.asList(TestHelper.getModel(IssuePriority.class).get(0)), Arrays.asList(TestHelper.getModel(IssueCategory.class).get(0)), Arrays.asList(TestHelper.getModel(News.class).get(0)), Arrays.asList(TestHelper.getModel(TimeEntry.class).get(0)));
        Issue issue = TestHelper.getModel(Issue.class).get(0);
        User user = TestHelper.getModel(User.class).get(0);
        issue.setIsPrivate(true);
        user.setSalt("38006729a049cd820aafd6c2bb3b193f");
        try {
            action.run("single2", null, Arrays.asList(issue), null, null, Arrays.asList(user), null, null, null, null, null, null);
        }
        finally {
            issue.setIsPrivate(false);
            user.setSalt(null);
        }
    }

    @Test
    public void testReadArray() throws Exception {
        TestAction action = new TestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected <T> void runForType(File rootDir, Class<T> type, List<?> expected) throws Exception {
                File file = new File(rootDir, Introspector.decapitalize(type.getSimpleName()) + "s.xml");
                if (RedmineXpp3HelperTest.this.verbose) {
                    log.info((Object)("will test " + TestHelper.getRelativePath(TestHelper.getBasedir(), file)));
                }
                Object[] actual = builder.readObjects(type, file, true);
                TestHelper.assertMyListEquals(type, expected, actual);
                FileInputStream input = new FileInputStream(file);
                try {
                    String txt = IOUtil.toString((InputStream)input);
                    actual = builder.readObjects(type, txt, true);
                    TestHelper.assertMyListEquals(type, expected, actual);
                }
                finally {
                    input.close();
                }
            }
        };
        action.run("array-empty", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        action.run("array-singleton", Arrays.asList(TestHelper.getModel(Attachment.class).get(0)), Arrays.asList(TestHelper.getModel(Issue.class).get(0)), Arrays.asList(TestHelper.getModel(Project.class).get(0)), Arrays.asList(TestHelper.getModel(Tracker.class).get(0)), Arrays.asList(TestHelper.getModel(User.class).get(0)), Arrays.asList(TestHelper.getModel(Version.class).get(0)), Arrays.asList(TestHelper.getModel(IssueStatus.class).get(0)), Arrays.asList(TestHelper.getModel(IssuePriority.class).get(0)), Arrays.asList(TestHelper.getModel(IssueCategory.class).get(0)), Arrays.asList(TestHelper.getModel(News.class).get(0)), Arrays.asList(TestHelper.getModel(TimeEntry.class).get(0)));
        action.run("array-multi", TestHelper.getModel(Attachment.class), TestHelper.getModel(Issue.class), TestHelper.getModel(Project.class), TestHelper.getModel(Tracker.class), TestHelper.getModel(User.class), TestHelper.getModel(Version.class), TestHelper.getModel(IssueStatus.class), TestHelper.getModel(IssuePriority.class), TestHelper.getModel(IssueCategory.class), TestHelper.getModel(News.class), TestHelper.getModel(TimeEntry.class));
    }

    public static abstract class TestAction {
        protected abstract <T> void runForType(File var1, Class<T> var2, List<?> var3) throws Exception;

        public void run(String name, List<?> ... expected) throws Exception {
            Assert.assertEquals((long)universeSize, (long)expected.length);
            File rootDir = new File(testDir, name);
            for (int i = 0; i < universeSize; ++i) {
                RedmineModelEnum next = TYPE_ORDER[i];
                if (expected[i] == null) continue;
                this.runForType(rootDir, next.getModelType(), expected[i]);
            }
        }
    }
}

