/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: ProjectXpp3Reader.java 211 2011-06-04 17:01:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.3/jredmine-client/src/main/java/org/nuiton/jredmine/model/io/xpp3/ProjectXpp3Reader.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model.io.xpp3;

import org.nuiton.io.xpp3.AbstractXpp3Reader;
import org.nuiton.jredmine.model.Project;

import java.beans.IntrospectionException;

import static org.nuiton.io.xpp3.Xpp3Helper.addTagTextContentMappers;

/**
 * {@link Project} reader.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public class ProjectXpp3Reader extends AbstractXpp3Reader<Project> {

    public ProjectXpp3Reader() {
        super(Project.class, "projects", "project");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(Project.class, RedmineDataConverter.Integer, true, allMappers,
                                 "id",
                                 "lft",
                                 "rgt",
                                 "parent-id",
                                 "projects-count",
                                 "status");

        addTagTextContentMappers(Project.class, RedmineDataConverter.Boolean, true, allMappers,
                                 "is-public");

        addTagTextContentMappers(Project.class, RedmineDataConverter.Datetime, true, allMappers,
                                 "created-on",
                                 "updated-on");

        addTagTextContentMappers(Project.class, RedmineDataConverter.Text, true, allMappers,
                                 "description",
                                 "homepage",
                                 "identifier",
                                 "name");
    }
}
