/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: DefaultRedmineService.java 211 2011-06-04 17:01:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2.2/jredmine-client/src/main/java/org/nuiton/jredmine/DefaultRedmineService.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

/**
 * Default {@link RedmineService} implementation based on a {@link RestClient}
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.jredmine.RedmineService" role-hint="default"
 * @since 1.0.0
 */
public class DefaultRedmineService extends DefaultRedmineAnonymousService implements RedmineService {

    protected static final Log log = LogFactory.getLog(DefaultRedmineService.class);

    ///////////////////////////////////////////////////////////////////////////
    /// RedmineServiceImplementor implementation
    ///////////////////////////////////////////////////////////////////////////
    @Override
    public RedmineServiceImplementor init(RestClientConfiguration configuration) throws RedmineServiceException {
        RedmineServiceImplementor result = delegateImplementor.init(configuration);
        return result;
    }

    @Override
    public RedmineServiceImplementor init(RestClient session) throws RedmineServiceException {
        return delegateImplementor.init(session);
    }

    ///////////////////////////////////////////////////////////////////////////
    /// RedmineLogguedService implementation
    ///////////////////////////////////////////////////////////////////////////

    @Override
    public Project[] getUserProjects() throws RedmineServiceException {
        checkLoggued();
        Project[] result = getDatas(RedmineRestClient.GET_USER_PROJECTS, Project.class);
        return result;
    }

    @Override
    public Version addVersion(String projectName,
                              Version version) throws RedmineServiceException {

        // send data and obtain created version
        Version result = sendData(RedmineRestClient.ADD_VERSION,
                                  Version.class,
                                  projectName,
                                  version
        );
        return result;
    }

    @Override
    public Version updateVersion(String projectName,
                                 Version version) throws RedmineServiceException {

        // send data and obtain updated version
        Version result = sendData(RedmineRestClient.UPDATE_VERSION,
                                  Version.class,
                                  projectName,
                                  version
        );
        return result;
    }

    @Override
    public Version nextVersion(String projectName,
                               String oldVersionName,
                               Version newVersion) throws RedmineServiceException {

        // send data and obtain updated or created new version
        Version result = sendData(RedmineRestClient.NEXT_VERSION,
                                  Version.class,
                                  projectName,
                                  newVersion,
                                  oldVersionName
        );
        return result;
    }

    @Override
    public Attachment addAttachment(String projectName,
                                    String versionName,
                                    Attachment attachement) throws RedmineServiceException {

        // send data and obtain created attachment
        Attachment result = sendData(RedmineRestClient.ADD_ATTACHMENT,
                                     Attachment.class,
                                     projectName,
                                     versionName,
                                     attachement
        );
        return result;
    }

    @Override
    public News addNews(String projectName,
                        News news) throws RedmineServiceException {
        // send data and obtain created news
        News result = sendData(RedmineRestClient.ADD_NEWS,
                               News.class,
                               projectName,
                               news
        );
        return result;
    }

    @Override
    public TimeEntry addIssueTimeEntry(String projectName,
                                       String issueId,
                                       TimeEntry entry) throws RedmineServiceException {
        // send data and obtain updated version
        TimeEntry result = sendData(RedmineRestClient.ADD_ISSUE_TIME_ENTRY,
                                    TimeEntry.class,
                                    projectName,
                                    issueId,
                                    entry
        );
        return result;
    }
}
