/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: ErrorDialogUIHandler.java 2221 2011-02-16 21:27:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.8/jaxx-widgets/src/main/java/jaxx/runtime/swing/ErrorDialogUIHandler.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;

import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * Handler of ui {@link ErrorDialogUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class ErrorDialogUIHandler {

    protected final ErrorDialogUI ui;

    public ErrorDialogUIHandler(ErrorDialogUI ui) {
        this.ui = ui;
    }

    public static void init(Frame frame) {
        disposeUI();
        ErrorDialogUI.instance = new ErrorDialogUI(frame);
        ErrorDialogUI.instance.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
    }

    public static void showError(Exception e) {
        ErrorDialogUI instance = ErrorDialogUI.instance;
        if (instance == null) {
            instance = new ErrorDialogUI();
        }
        instance.getErrorMessage().setText(e.getMessage());
        StringWriter w = new StringWriter();
        PrintWriter writer = new PrintWriter(w);
        try {
            e.printStackTrace(writer);
            instance.getErrorStack().setText(w.toString());
        } finally {
            writer.close();
        }
        instance.getErrorStack().setCaretPosition(0);
        instance.pack();
        SwingUtil.center(instance.getContextValue(JFrame.class, "parent"), instance);
        instance.setVisible(true);
    }

    public static void disposeUI() {
        ErrorDialogUI instance = ErrorDialogUI.instance;
        if (instance != null) {
            JAXXUtil.destroy(instance);
        }
        ErrorDialogUI.instance = null;
    }

    void $afterCompleteSetup() {
        JRootPane rootPane = ui.getRootPane();

        JButton close = ui.close;
        rootPane.setDefaultButton(close);
        InputMap inputMap = rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", close.getAction());
    }
}
