package jaxx.runtime.swing.editor.config;
/*
 * #%L
 * JAXX :: Widgets
 * $Id: ConfigCategoryUIHandler.java 2479 2012-08-08 12:23:08Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.6/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/config/ConfigCategoryUIHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.config.model.ConfigTableModel;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import jaxx.runtime.swing.renderer.ClassTableCellRenderer;
import jaxx.runtime.swing.renderer.ColorCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import java.awt.Color;
import java.awt.Font;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * Handler of {@link ConfigCategoryUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.4
 */
public class ConfigCategoryUIHandler {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ConfigCategoryUIHandler.class);

    private final ConfigCategoryUI ui;

    public ConfigCategoryUIHandler(ConfigCategoryUI ui) {
        this.ui = ui;
    }

    public void init() {

        JTable table = ui.getTable();

        // prepare table
        SwingUtil.setI18nTableHeaderRenderer(
                table,
                n_("config.key"),
                n_("config.key.tip"),
                n_("config.value"),
                n_("config.value.tip"),
                n_("config.defaultValue"),
                n_("config.defaultValue.tip"));

        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer(table, 0, renderer);
        SwingUtil.setTableColumnRenderer(table, 1, renderer);
        SwingUtil.setTableColumnRenderer(table, 2, renderer);
        Font f = table.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        int width = SwingUtil.computeTableColumnWidth(table, f, 0, "___*");
        SwingUtil.fixTableColumnWidth(table, 0, width);
        SwingUtil.setTableColumnEditor(table, 1, new ConfigTableEditor((ConfigTableModel) table.getModel()));
        table.setDefaultRenderer(Color.class, new ColorCellRenderer());
        table.setDefaultRenderer(Class.class, new ClassTableCellRenderer());
    }

    public void updateDescriptionText() {
        OptionModel option;
        JTable table = ui.getTable();
        JTextArea description = ui.getDescription();
        ListSelectionModel selectionModel = ui.getSelectionModel();

        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel) table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug(row + " : " + option);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(_("config.no.option.selected"));
        } else {
            buffer.append(_("config.option.label", option.getKey(), _(option.getDescription()))).append('\n');
            if (option.isModified()) {
                buffer.append(_("config.option.modified", option.getOriginalValue(), option.getValue())).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(_("config.option.final")).append('\n');
            }
        }
        description.setText(buffer.toString());
    }
}
