/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor.config;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.config.*;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ConfigUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TTW/TQBCdpE3aJOWrVUMRRSrQCxI4ReJEEBQKUVulUNEgVeTCJl6SrTberb2mrhCIn8BPgDsXJG6cEAfOHLgg/gJCHLgiZtdOXDdGqSVv4p15b2fevnn3E3KeC+d3SBBYru8o1qPW+u3t7QetHdpWd6nXdplUwoXwyWQh24SSPdj3FFxs1jW8EsErK6InhUOdA+hqHYqe2ufU61KqFJxLItqeV9kahKuB9N0+66CoNNY3v39lX9uv3mYBAonV5bGVhVGouJPxOmSZrWAaT3pGKpw4HSzDZU4H6z2m91Y48bz7pEd34SVM1CEviYtkCi4cvWXDYfCBVDC5uL5JHMqXFFxKVOrt4bkWtRlirbZwnrIOVq9/Hq1JaQjyCia6xLE5dRUsHRm9GkJiklxP2JQruDaSwiQOiDb0V0xTbBNFO8JlFE1wWssVRCTrDdJqUVs3qnMLA0i/+6soegJgdpO547s+Q6VnEnl3fKWEozNmJV722UQHaCMrtlF8z5km5Fyf6zLnmsPOe4ih0HNzhzynCU30b3nm28cfH2p9o43j2bOpqQfmBA0gXSHxsoxCJ0KX+YrxygaR1SYUPMpxyMwQzacUthWFsTg875SGWxpurRKvixS5ie+fPpeffB2DbA2KXBC7RnT+GhRU10UVBLcDeWvZVDS1N4nrSXzHUFtFA9R2OrpmRDHhWKHgxfBrDWMKSmHGlTBUUkLwBpMNgy4Poy3FZIBCzqcIOeimVfjyZ2br/XJfzAw2d+a/6bGguceQZw5nDjVzG41k6pyWpEd9W8SjlzaMEHlMRpZeMOvikF4ZBVOKtDY5adOemf7p5wccbtXv1RovAl+DL5t29D8LEgNyhDPynOwLtDccv2ETRRZazLHR8zeHmDN6LY5k1NvX9VJNZygjwz98r7YB/wUAAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.config.ConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTabbedPane categories;
    protected jaxx.runtime.swing.editor.config.ConfigUIHandler handler;
    protected jaxx.runtime.swing.editor.config.model.ConfigUIModel model;
    protected javax.swing.JButton quit;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void init(String defaultCategory) {
        getHandler().initUI(defaultCategory);
    }
    
    public void destroy() {
        log.info("destroy ui " + getName());
        JAXXUtil.destroy(this);
        model.destroy();
    }
    
    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        destroy();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigUI() {
        $initialize();
    }

    public ConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__categories(javax.swing.event.ChangeEvent event) {
        getHandler().changeCategory(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTabbedPane getCategories() {
        return categories;
    }

    public jaxx.runtime.swing.editor.config.ConfigUIHandler getHandler() {
        return handler;
    }

    public jaxx.runtime.swing.editor.config.model.ConfigUIModel getModel() {
        return model;
    }

    public javax.swing.JButton getQuit() {
        return quit;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCategories() {
        $objectMap.put("categories", categories = new javax.swing.JTabbedPane());
        categories.setName("categories");
        categories.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__categories"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.editor.config.ConfigUIHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createQuit() {
        $objectMap.put("quit", quit = new javax.swing.JButton());
        quit.setName("quit");
        quit.setText(_("config.action.quit"));
        quit.setToolTipText(_("config.action.quit.tip"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(categories, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        // inline complete setup of $JPanel1
        $JPanel1.add(quit);
        
        // apply 4 property setters
        categories.setTabPlacement(JTabbedPane.LEFT);
        quit.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config-quit"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createHandler();
        createModel();
        createCategories();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createQuit();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}