/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ErrorDialogUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU8TQRieVlraAkEhfChoQBvjQbfEa42CIJGmqLGYEHtx2h3bwenOODMrqwfjT/An6N2LiTdPxoNnD16Mf8EYD16N78y2uxQWbEIPu837Ps/zfuR99t1PlFESLe7gIHCk72naIU5lZXv7bmOHNPUaUU1JheYShb9UGqXraMSN4kqjC/WqoZe69NIq7wjuEW8Pu1xFBaWfM6LahGiNzvYzmkqValG6HAhf9lSjppJU3/z+lX7tvnqbRigQ0F0eRln4HyueZKiK0tTVaAIqPcMlhr0WtCGp14J+x0xslWGl7uAOeYpeouEqygosQUyj84OPbDUsPxAa5YuVNYoZby3pfa2qXSjs3JKSyxDxYEMIS8xqNFmsWd0Nj2pI0hdEgsBFK9CE4pQR6YSlnQPIWGa4uIUbjAB1NqG2zRlkPiLkipV72CMMGBNmIUEXGkYNaHwvtoobCVgbNaCJCDtKzJybRCncsiVn+rXGihUYgzNm6oDgTJ9gnOpnFaxqTePmE42m+ihbJNArkmCDPBMRMk3GFYH19mFv+lpzryst0VzfquBWnfhW42NK1VFG+hCG3dYPnvd9SIWHPbvvsI2gzf6dnvz28ceH9d4156D2VCJ0jxnhyoTkgkhNTenx8JR9TVlpE4tyHTxBGDjZOnU+obFaNw3NQb1Thu4YunMbqzZIZIa/f/o8/ejrCZReRwXGsbuODX4D5XVbwhY4cwNxY9l2NLqbg+dJ0xsst8NdzOAYrlGPUY8sYA3maviaXA9gD/MJe4iaaeS//JmsvV/u7SIFvZ0+FB7vI/MQZcNq1ttd2yZ6eUQo4rs8tmeSYVPmXRBdB12yz8uJw2qqQ/OUAt+8lmzX5t/VgUWGNFzpERrTA2hk24S22kepzA0yzi58GNvHFMkRl+reN+UQnXMD6OQfc09fUfApO5aQCZePUFgEhX94qbH3EAcAAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.ErrorDialogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton close;
    protected javax.swing.JLabel errorMessage;
    protected javax.swing.JTextArea errorStack;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ErrorDialogUI $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected static ErrorDialogUI instance;
    
    public static void init(Frame frame) {
        disposeUI();
        instance = new ErrorDialogUI(frame);
        instance.setModalityType(ModalityType.TOOLKIT_MODAL);
    }
    public static void showError(Exception e) {
        if (instance == null) {
            instance = new ErrorDialogUI();
        }
        instance.getErrorMessage().setText(e.getMessage());
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        instance.getErrorStack().setText(w.toString());
        instance.getErrorStack().setCaretPosition(0);
        instance.pack();
        jaxx.runtime.SwingUtil.center(instance.getContextValue(JFrame.class,"parent"), instance);
        instance.setVisible(true);
    }
    public static void disposeUI() {
        if (instance != null) {
            JAXXUtil.destroy(instance);
        }
        instance=null;
    }
    
    public  ErrorDialogUI(Frame frame) {
        super(frame);$initialize();
    
        if (frame!=null) {
            setContextValue(frame);
            setContextValue(frame,"parent");
        }
    
    $initialize();
    }JRootPane rootPane;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ErrorDialogUI() {
        $initialize();
    }

    public ErrorDialogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__close(java.awt.event.ActionEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getClose() {
        return close;
    }

    public javax.swing.JLabel getErrorMessage() {
        return errorMessage;
    }

    public javax.swing.JTextArea getErrorStack() {
        return errorStack;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createClose() {
        $objectMap.put("close", close = new javax.swing.JButton());
        close.setName("close");
        close.setText(_("errorUI.action.close"));
        close.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__close"));
    }

    protected void createErrorMessage() {
        $objectMap.put("errorMessage", errorMessage = new javax.swing.JLabel());
        errorMessage.setName("errorMessage");
    }

    protected void createErrorStack() {
        $objectMap.put("errorStack", errorStack = new javax.swing.JTextArea());
        errorStack.setName("errorStack");
        errorStack.setColumns(15);
        errorStack.setLineWrap(true);
        errorStack.setWrapStyleWord(true);
        errorStack.setEditable(false);
        if (errorStack.getFont() != null) {
            errorStack.setFont(errorStack.getFont().deriveFont((float) 9));
        }
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(errorMessage, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(close, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel0);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorStack);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        rootPane = getRootPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        $JPanel0.setName("$JPanel0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("errorUI.message"));
        createErrorMessage();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        SwingUtil.setComponentHeight($JScrollPane0,200);
        SwingUtil.setComponentWidth($JScrollPane0,600);
        createErrorStack();
        createClose();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(_("errorUI.title"));
        
        rootPane.setDefaultButton(close);rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"), "close");rootPane.getActionMap().put("close", close.getAction());$completeSetup();
    }

}