package jaxx.runtime.swing;

import jaxx.runtime.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import org.nuiton.util.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AboutPanel extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final String PROPERTY_ABOUT_TEXT = "aboutText";
    public static final String PROPERTY_BACKGROUND_COLOR = "backgroundColor";
    public static final String PROPERTY_BOTTOM_TEXT = "bottomText";
    public static final String PROPERTY_ICON_PATH = "iconPath";
    public static final String PROPERTY_LICENSE_TEXT = "licenseText";
    public static final String PROPERTY_THIRDPARTY_TEXT = "thirdpartyText";
    public static final String PROPERTY_TITLE = "title";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.AboutPanel.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW/cRBiebLNJNts2baK2gaYohUiAUL39rlCqtiEQkWhL024kKvbS8XqSnXbWMx2/bpweEOIX8BPgzgWJGyfEgTMHLoi/gBAHroh3bK+9TryuVefg3bwfzzzvMzOP9/u/SN3T5OJTGgSW9l3gA2ZtrT1+/MB+ynrwMfN6miuQmkR/EzVS65Kmk8Q9IO9026a9Fbe31uVASZe5I92rbTLrwYFgXp8xAHIh29HzvFYnSa8GytdD1IRUHuq3//xd+8b56rsaIYFCdos4yvKrutJJJtukxh0g87jSC9oS1N1DGpq7e8j3hImtC+p5n9EBe06+JNNtMqWoRjAgb5cfOcQI+wMFZHplh9qCXUYNMkS9fVzWWrOlD9vUZUKpsGcKSB04CAbklCFkGZJWRDItmeE96W5T6Jv/T6bxBjV4OyyAQ4lZWwLIQU6mKXiPuR7LSZ2EPtcOKgAHOdk5m/ae7Wnpu866FFJjfUiY7oMVBkbormyFM15B6U1NEE8fRU1RY7S2TW0mrh6uDaOmaCmtBakSiLeyOJNAbTyr5zIYuBU2c0xLtvh4qNu6dCHc7GxTp6elEMOmlaTpxMrWJw7HnTepa4e70pQpfzcVNdY7XsxE38/izo3syJpmFMiZ7BBx3JRfSrpOp5s1Hno+u6NDlCvmcfXIdl3PkbUZHaRkMy6ax8307PaE9PDsLmQYf+Rjj5utbJh7senuyhtA3sy5GXFWHW24aQJ3cxK3hglNzmcQ0W6s1G5SP5jokrr2MQxksXvUoR5hKvKmxUPeZADD7H9nF37/6c8fN4aGdB7XPpNbOuKnaBRKS8U0cLP0XORGPnDRuk/Vapc0PCbQjEOzXcoh1onTSA7XOx1eO9NufUq9PkLUp//4+ZezT347RmobZFZI6mxQU79JGtDXqIIUTqDu3gsZHd+fwecpw834RHKp8ajedijQZZu7Du7InQCFWMoRImFjN379d6Hzw72hGBNI7o2x5akg9S/IFHcFd1noz7H15vpxU3nMd2RqsXmmO2E+Z1V8QjbD5/28aadsqR2mTX478M3Hw5C2+dYpiWLCDwoQLpThIegB+k9FlMYu3vtLHn+JR3z+diToMgV8ddg+sDv5wMslgCchdv8x5MpgTL/gHsf3YCUYE/68AOG9yggflBil2Yv8dedAhePsvj7UDMO3BI1leW0cE35WaahXyWJVRrhcCuHrAh3KIRQpWQ6hSMlyCEU6XKuMcKOykuUQipQsh1CkZDmEJwUIt0rcr4W+1PwlXlcq1gTfcwfxz6IxkB9WHqscgqqEgO8LfJvz6AfVGJRVRPkfe73Dh+sNAAA=";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected javax.swing.JScrollPane aboutContent;
    protected java.lang.String aboutText;
    protected java.awt.Color backgroundColor;
    protected javax.swing.JLabel bottomLabel;
    protected java.lang.String bottomText;
    protected javax.swing.JButton close;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected java.lang.String iconPath;
    protected javax.swing.JScrollPane licenseContent;
    protected java.lang.String licenseText;
    protected javax.swing.JTextArea licenseTextArea;
    protected javax.swing.JTabbedPane tabs;
    protected javax.swing.JScrollPane thirdpartyContent;
    protected java.lang.String thirdpartyText;
    protected javax.swing.JTextArea thirdpartyTextArea;
    protected java.lang.String title;
    protected javax.swing.JPanel topPanel;
    private javax.swing.JEditorPane $JEditorPane3;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JPanel $JPanel4;
    private jaxx.runtime.swing.TabInfo $TabInfo5;
    private jaxx.runtime.swing.TabInfo $TabInfo6;
    private jaxx.runtime.swing.TabInfo $TabInfo7;
    private AboutPanel $Table0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource12 = new DataBindingListener(this, "$JLabel2.text");
    private PropertyChangeListener $DataSource13 = new DataBindingListener(this, "$JLabel2.visible");
    private PropertyChangeListener $DataSource16 = new DataBindingListener(this, "$JEditorPane3.text");
    private PropertyChangeListener $DataSource19 = new DataBindingListener(this, "licenseTextArea.text");
    private PropertyChangeListener $DataSource22 = new DataBindingListener(this, "thirdpartyTextArea.text");
    private PropertyChangeListener $DataSource25 = new DataBindingListener(this, "bottomLabel.text");
    private PropertyChangeListener $DataSource26 = new DataBindingListener(this, "bottomLabel.visible");
    private PropertyChangeListener $DataSource27 = new DataBindingListener(this, "close.action");
    private PropertyChangeListener $DataSource8 = new DataBindingListener(this, "$Table0.background");

    /* begin raw body code */
    final Action closeAction = new AbstractAction("close") {
        private static final long serialVersionUID = 1L;
    
        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog container = getParentContainer(JDialog.class);
            if (container != null) {
                container.dispose();
            } else {
                setVisible(false);
            }
        }
    };
    
    
    public void setLicenseFile(String filename) {
        String load = load(filename);
        setLicenseText(load);
    }
    
    public void setThirdpartyFile(String filename) {
        String load = load(filename);
        setThirdpartyText(load);
    }
    
    public void buildTopPanel() {
        // image
        JLabel labelIcon;
        if (iconPath != null) {
            Icon logoIcon = Resource.getIcon(iconPath);
            labelIcon = new JLabel(logoIcon);
        } else {
            labelIcon = new JLabel();
        }
        topPanel.add(labelIcon);
    }
    
    public void init() {
        if (getAboutText() == null) {
            tabs.remove(aboutContent);
        }
        if (getLicenseText() == null) {
            tabs.remove(licenseContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {
    
                @Override
                public void run() {
                    licenseTextArea.setCaretPosition(0);
                }
            });
    
        }
        if (getThirdpartyText() == null) {
            tabs.remove(thirdpartyContent);
        } else {
            SwingUtilities.invokeLater(new Runnable() {
    
                @Override
                public void run() {
                    thirdpartyTextArea.setCaretPosition(0);
                }
            });
        }
    }
    
    public void showInDialog(Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, true);
        f.add(this);
        if (iconPath != null) {
            f.setIconImage(SwingUtil.createIcon(iconPath).getImage());
        }
        f.setResizable(false);
        f.setSize(550, 450);
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.setDefaultButton(close);
        rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", closeAction);
        SwingUtil.center(ui, f);
        f.setVisible(true);
    }
    
    protected String load(String filename) {
        InputStream licenseStream = getClass().getResourceAsStream("/" + filename);
        String result = null;
        try {
            if (licenseStream != null) {
                result = IOUtils.toString(licenseStream);
            }
        } catch (IOException ex) {
           // ignore it
        } finally {
            if (licenseStream != null) {
                try {
                    licenseStream.close();
                } catch (IOException ex) {
                    log.error("could not close file " + filename);
                }
            }
        }
        if (result == null) {
            result = "resource " + filename + " not found";
        }
        return result;
    }
    
    void $afterCompleteSetup() {
        buildTopPanel();
        close.setText(_("aboutframe.ok"));
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public AboutPanel() {
        $initialize();
    }

    public AboutPanel(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$Table0.background".equals($binding)) {    
            addPropertyChangeListener("backgroundColor", $DataSource8);
        } else if ("$JLabel2.text".equals($binding)) {    
            addPropertyChangeListener("title", $DataSource12);
        } else if ("$JLabel2.visible".equals($binding)) {    
            addPropertyChangeListener("title", $DataSource13);
        } else if ("$JEditorPane3.text".equals($binding)) {    
            addPropertyChangeListener("aboutText", $DataSource16);
        } else if ("licenseTextArea.text".equals($binding)) {    
            addPropertyChangeListener("licenseText", $DataSource19);
        } else if ("thirdpartyTextArea.text".equals($binding)) {    
            addPropertyChangeListener("thirdpartyText", $DataSource22);
        } else if ("bottomLabel.text".equals($binding)) {    
            addPropertyChangeListener("bottomText", $DataSource25);
        } else if ("bottomLabel.visible".equals($binding)) {    
            addPropertyChangeListener("bottomText", $DataSource26);
        } else if ("close.action".equals($binding)) {    
            addPropertyChangeListener("closeAction", $DataSource27);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$Table0.background".equals($dest)) {
                setBackground(getBackgroundColor());
            } else if ("$JLabel2.text".equals($dest)) {
                $JLabel2.setText(_(SwingUtil.getStringValue(getTitle())));
            } else if ("$JLabel2.visible".equals($dest)) {
                $JLabel2.setVisible(getTitle() != null);
            } else if ("$JEditorPane3.text".equals($dest)) {
                jaxx.runtime.SwingUtil.setText($JEditorPane3, SwingUtil.getStringValue(getAboutText()));
            } else if ("licenseTextArea.text".equals($dest)) {
                jaxx.runtime.SwingUtil.setText(licenseTextArea, SwingUtil.getStringValue(getLicenseText()));
            } else if ("thirdpartyTextArea.text".equals($dest)) {
                jaxx.runtime.SwingUtil.setText(thirdpartyTextArea, SwingUtil.getStringValue(getThirdpartyText()));
            } else if ("bottomLabel.text".equals($dest)) {
                bottomLabel.setText(_(SwingUtil.getStringValue(getBottomText())));
            } else if ("bottomLabel.visible".equals($dest)) {
                bottomLabel.setVisible(getBottomText() != null);
            } else if ("close.action".equals($dest)) {
                close.setAction(closeAction);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$Table0.background".equals($binding)) {    
            removePropertyChangeListener("backgroundColor", $DataSource8);
        } else if ("$JLabel2.text".equals($binding)) {    
            removePropertyChangeListener("title", $DataSource12);
        } else if ("$JLabel2.visible".equals($binding)) {    
            removePropertyChangeListener("title", $DataSource13);
        } else if ("$JEditorPane3.text".equals($binding)) {    
            removePropertyChangeListener("aboutText", $DataSource16);
        } else if ("licenseTextArea.text".equals($binding)) {    
            removePropertyChangeListener("licenseText", $DataSource19);
        } else if ("thirdpartyTextArea.text".equals($binding)) {    
            removePropertyChangeListener("thirdpartyText", $DataSource22);
        } else if ("bottomLabel.text".equals($binding)) {    
            removePropertyChangeListener("bottomText", $DataSource25);
        } else if ("bottomLabel.visible".equals($binding)) {    
            removePropertyChangeListener("bottomText", $DataSource26);
        } else if ("close.action".equals($binding)) {    
            removePropertyChangeListener("closeAction", $DataSource27);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doHyperlinkUpdate__on__$JEditorPane3(javax.swing.event.HyperlinkEvent event) {
        SwingUtil.openLink(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JScrollPane getAboutContent() {
        return aboutContent;
    }

    public java.lang.String getAboutText() {
        return aboutText;
    }

    public java.awt.Color getBackgroundColor() {
        return backgroundColor;
    }

    public javax.swing.JLabel getBottomLabel() {
        return bottomLabel;
    }

    public java.lang.String getBottomText() {
        return bottomText;
    }

    public javax.swing.JButton getClose() {
        return close;
    }

    public java.lang.String getIconPath() {
        return iconPath;
    }

    public javax.swing.JScrollPane getLicenseContent() {
        return licenseContent;
    }

    public java.lang.String getLicenseText() {
        return licenseText;
    }

    public javax.swing.JTextArea getLicenseTextArea() {
        return licenseTextArea;
    }

    public javax.swing.JTabbedPane getTabs() {
        return tabs;
    }

    public javax.swing.JScrollPane getThirdpartyContent() {
        return thirdpartyContent;
    }

    public java.lang.String getThirdpartyText() {
        return thirdpartyText;
    }

    public javax.swing.JTextArea getThirdpartyTextArea() {
        return thirdpartyTextArea;
    }

    public java.lang.String getTitle() {
        return title;
    }

    public javax.swing.JPanel getTopPanel() {
        return topPanel;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAboutText(java.lang.String newValue) {
        java.lang.String oldValue = this.aboutText;
        this.aboutText = newValue;
        firePropertyChange(PROPERTY_ABOUT_TEXT, oldValue, newValue);
    }

    public void setBackgroundColor(java.awt.Color newValue) {
        java.awt.Color oldValue = this.backgroundColor;
        this.backgroundColor = newValue;
        firePropertyChange(PROPERTY_BACKGROUND_COLOR, oldValue, newValue);
    }

    public void setBottomText(java.lang.String newValue) {
        java.lang.String oldValue = this.bottomText;
        this.bottomText = newValue;
        firePropertyChange(PROPERTY_BOTTOM_TEXT, oldValue, newValue);
    }

    public void setIconPath(java.lang.String newValue) {
        java.lang.String oldValue = this.iconPath;
        this.iconPath = newValue;
        firePropertyChange(PROPERTY_ICON_PATH, oldValue, newValue);
    }

    public void setLicenseText(java.lang.String newValue) {
        java.lang.String oldValue = this.licenseText;
        this.licenseText = newValue;
        firePropertyChange(PROPERTY_LICENSE_TEXT, oldValue, newValue);
    }

    public void setThirdpartyText(java.lang.String newValue) {
        java.lang.String oldValue = this.thirdpartyText;
        this.thirdpartyText = newValue;
        firePropertyChange(PROPERTY_THIRDPARTY_TEXT, oldValue, newValue);
    }

    public void setTitle(java.lang.String newValue) {
        java.lang.String oldValue = this.title;
        this.title = newValue;
        firePropertyChange(PROPERTY_TITLE, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JEditorPane get$JEditorPane3() {
        return $JEditorPane3;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo7() {
        return $TabInfo7;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add(tabs, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        add($JPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel2, BorderLayout.CENTER);
        addChildrenToTabs();
        addChildrenToAboutContent();
        addChildrenToLicenseContent();
        addChildrenToThirdpartyContent();
        // inline complete setup of $JPanel4
        $JPanel4.add(bottomLabel, BorderLayout.CENTER);
        $JPanel4.add(close, BorderLayout.EAST);
        // init data bindings
        applyDataBinding("$Table0.background");
        setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        $JPanel1.setBackground(Color.WHITE);
        applyDataBinding("$JLabel2.text");
        applyDataBinding("$JLabel2.visible");
        aboutContent.setBorder(null);
        $JEditorPane3.setBorder(null);
        applyDataBinding("$JEditorPane3.text");
        licenseContent.setBorder(null);
        licenseTextArea.setBorder(null);
        applyDataBinding("licenseTextArea.text");
        thirdpartyContent.setBorder(null);
        thirdpartyTextArea.setBorder(null);
        applyDataBinding("thirdpartyTextArea.text");
        bottomLabel.setHorizontalAlignment(SwingConstants.CENTER);
        applyDataBinding("bottomLabel.text");
        applyDataBinding("bottomLabel.visible");
        applyDataBinding("close.action");
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createTitle();
        createIconPath();
        createAboutText();
        createBottomText();
        createLicenseText();
        createThirdpartyText();
        createBackgroundColor();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        if ($JLabel2.getFont() != null) {
            $JLabel2.setFont($JLabel2.getFont().deriveFont((float) 12));
        }
        createTopPanel();
        createTabs();
        createAboutContent();
        // inline creation of $JEditorPane3
        $objectMap.put("$JEditorPane3", $JEditorPane3 = new javax.swing.JEditorPane());
        $JEditorPane3.setName("$JEditorPane3");
        $JEditorPane3.setContentType("text/html");
        $JEditorPane3.setEditable(false);
        $JEditorPane3.addHyperlinkListener(Util.getEventListener(HyperlinkListener.class, "hyperlinkUpdate", this, "doHyperlinkUpdate__on__$JEditorPane3"));
        createLicenseContent();
        createLicenseTextArea();
        createThirdpartyContent();
        createThirdpartyTextArea();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new javax.swing.JPanel());
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new BorderLayout());
        createBottomLabel();
        createClose();
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new jaxx.runtime.swing.TabInfo());
        $TabInfo5.setTitle(_("aboutframe.about"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new jaxx.runtime.swing.TabInfo());
        $TabInfo6.setTitle(_("aboutframe.license"));
        // inline creation of $TabInfo7
        $objectMap.put("$TabInfo7", $TabInfo7 = new jaxx.runtime.swing.TabInfo());
        $TabInfo7.setTitle(_("aboutframe.thirdparty"));
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

    protected void addChildrenToAboutContent() {
        if (!allComponentsCreated) {
            return;
        }
        aboutContent.getViewport().add($JEditorPane3);
    }

    protected void addChildrenToLicenseContent() {
        if (!allComponentsCreated) {
            return;
        }
        licenseContent.getViewport().add(licenseTextArea);
    }

    protected void addChildrenToTabs() {
        if (!allComponentsCreated) {
            return;
        }
        tabs.add(aboutContent);
        tabs.add(licenseContent);
        tabs.add(thirdpartyContent);
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 0));
        tabs.setTitleAt(0, _("aboutframe.about"));
        $TabInfo6.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 1));
        tabs.setTitleAt(1, _("aboutframe.license"));
        $TabInfo7.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(tabs, 2));
        tabs.setTitleAt(2, _("aboutframe.thirdparty"));
    }

    protected void addChildrenToThirdpartyContent() {
        if (!allComponentsCreated) {
            return;
        }
        thirdpartyContent.getViewport().add(thirdpartyTextArea);
    }

    protected void createAboutContent() {
        $objectMap.put("aboutContent", aboutContent = new javax.swing.JScrollPane());
        aboutContent.setName("aboutContent");
    }

    protected void createAboutText() {
        $objectMap.put("aboutText", aboutText = null);
    }

    protected void createBackgroundColor() {
        $objectMap.put("backgroundColor", backgroundColor = null);
    }

    protected void createBottomLabel() {
        $objectMap.put("bottomLabel", bottomLabel = new javax.swing.JLabel());
        bottomLabel.setName("bottomLabel");
    }

    protected void createBottomText() {
        $objectMap.put("bottomText", bottomText = null);
    }

    protected void createClose() {
        $objectMap.put("close", close = new javax.swing.JButton());
        close.setName("close");
    }

    protected void createIconPath() {
        $objectMap.put("iconPath", iconPath = null);
    }

    protected void createLicenseContent() {
        $objectMap.put("licenseContent", licenseContent = new javax.swing.JScrollPane());
        licenseContent.setName("licenseContent");
    }

    protected void createLicenseText() {
        $objectMap.put("licenseText", licenseText = null);
    }

    protected void createLicenseTextArea() {
        $objectMap.put("licenseTextArea", licenseTextArea = new javax.swing.JTextArea());
        licenseTextArea.setName("licenseTextArea");
        licenseTextArea.setColumns(15);
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setWrapStyleWord(true);
        licenseTextArea.setEditable(false);
        if (licenseTextArea.getFont() != null) {
            licenseTextArea.setFont(licenseTextArea.getFont().deriveFont((float) 11));
        }
    }

    protected void createTabs() {
        $objectMap.put("tabs", tabs = new javax.swing.JTabbedPane());
        tabs.setName("tabs");
    }

    protected void createThirdpartyContent() {
        $objectMap.put("thirdpartyContent", thirdpartyContent = new javax.swing.JScrollPane());
        thirdpartyContent.setName("thirdpartyContent");
    }

    protected void createThirdpartyText() {
        $objectMap.put("thirdpartyText", thirdpartyText = null);
    }

    protected void createThirdpartyTextArea() {
        $objectMap.put("thirdpartyTextArea", thirdpartyTextArea = new javax.swing.JTextArea());
        thirdpartyTextArea.setName("thirdpartyTextArea");
        thirdpartyTextArea.setColumns(15);
        thirdpartyTextArea.setLineWrap(true);
        thirdpartyTextArea.setWrapStyleWord(true);
        thirdpartyTextArea.setEditable(false);
        if (thirdpartyTextArea.getFont() != null) {
            thirdpartyTextArea.setFont(thirdpartyTextArea.getFont().deriveFont((float) 11));
        }
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new javax.swing.JPanel());
        topPanel.setName("topPanel");
    }

}