/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageListMouseListener;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableMouseListener;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SwingValidatorUtil
extends BeanValidatorUtil {
    static ImageIcon fatalIcon;
    static ImageIcon errorIcon;
    static ImageIcon warningIcon;
    static ImageIcon infoIcon;
    private static final Log log;

    public static ImageIcon getFatalIcon() {
        if (fatalIcon == null) {
            fatalIcon = SwingUtil.createImageIcon((String)"fatal.png");
        }
        return fatalIcon;
    }

    public static ImageIcon getErrorIcon() {
        if (errorIcon == null) {
            errorIcon = SwingUtil.createImageIcon((String)"error.png");
        }
        return errorIcon;
    }

    public static ImageIcon getInfoIcon() {
        if (infoIcon == null) {
            infoIcon = SwingUtil.createImageIcon((String)"info.png");
        }
        return infoIcon;
    }

    public static ImageIcon getWarningIcon() {
        if (warningIcon == null) {
            warningIcon = SwingUtil.createImageIcon((String)"warning.png");
        }
        return warningIcon;
    }

    protected SwingValidatorUtil() {
    }

    public static void installUI(JTable errorTable, SwingValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n_((String)"validator.scope.header"), I18n.n_((String)"validator.scope.header.tip"), I18n.n_((String)"validator.field.header"), I18n.n_((String)"validator.field.header.tip"), I18n.n_((String)"validator.message.header"), I18n.n_((String)"validator.message.header.tip")});
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    public static SwingValidatorMessageListMouseListener registerErrorListMouseListener(JList list) {
        SwingValidatorMessageListMouseListener listener = SwingValidatorUtil.getErrorListMouseListener(list);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageListMouseListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)listener.toString());
        }
        list.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageTableMouseListener registerErrorTableMouseListener(JTable table) {
        SwingValidatorMessageTableMouseListener listener = SwingValidatorUtil.getErrorTableMouseListener(table);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageTableMouseListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)listener.toString());
        }
        table.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageListMouseListener getErrorListMouseListener(JList list) {
        if (list != null) {
            for (MouseListener listener : list.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageListMouseListener)) continue;
                return (SwingValidatorMessageListMouseListener)listener;
            }
        }
        return null;
    }

    public static SwingValidatorMessageTableMouseListener getErrorTableMouseListener(JTable table) {
        if (table != null) {
            for (MouseListener listener : table.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageTableMouseListener)listener;
            }
        }
        return null;
    }

    public static String getMessage(SwingValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getField().getI18nError(text);
        }
        return text;
    }

    public static String getFieldName(SwingValidatorMessage model, String value) {
        String text = null;
        JComponent editor = model.getEditor();
        if (editor != null) {
            text = (String)editor.getClientProperty("validatorLabel");
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    public static ImageIcon getIcon(BeanValidatorScope scope) {
        ImageIcon icon = null;
        switch (scope) {
            case FATAL: {
                icon = SwingValidatorUtil.getFatalIcon();
                break;
            }
            case ERROR: {
                icon = SwingValidatorUtil.getErrorIcon();
                break;
            }
            case WARNING: {
                icon = SwingValidatorUtil.getWarningIcon();
                break;
            }
            case INFO: {
                icon = SwingValidatorUtil.getInfoIcon();
            }
        }
        return icon;
    }

    public static void listenValidatorContextNameAndRefreshFields(SwingValidator<?> validator, final JAXXValidator ui) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingValidator validator = (SwingValidator)evt.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Context name changed to [" + evt.getNewValue() + "] for validator " + validator.getBeanClass()));
                }
                ui.registerValidatorFields();
            }
        };
        validator.addPropertyChangeListener("contextName", listener);
    }

    static {
        log = LogFactory.getLog(SwingValidatorUtil.class);
    }
}

