/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util.config;

import org.nuiton.jaxx.util.DialogUI;

import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

/**
 * A abstract dialog contract to be realised by a dialogUI (WindowEvent adapter)
 * <p/>
 * TODO : make jaxx authorized implementing interface for root tag :)
 *
 * @author chemit
 */
public abstract class DialogConfigUI<E extends Enum<E>, H extends DialogConfigUIHandler<E, ?, ?>> extends DialogUI<H> {

    public abstract AbstractButton getOk();

    public abstract AbstractButton getReset();

    public abstract AbstractButton getCancel();

    public JComponent getElement(E key) {
        Object id = getObjectById(key.name());
        if (id == null) {
            log.error(new NullPointerException("no widget for key "+key));
            return null;
        }
        if (!(id instanceof JComponent)) {
            throw new IllegalArgumentException(id + " is not a JComponent");
        }
        return (JComponent) id;
    }

    public Object getElementValue(E key) {
        JComponent o = getElement(key);
        if (o instanceof JPasswordField) {
            return new String(((JPasswordField) o).getPassword());
        }
        if (o instanceof JTextField) {
            return ((JTextField) o).getText();
        }
        if (o instanceof JRadioButton) {
            return ((JRadioButton) o).isSelected();
        }
        if (o instanceof JCheckBox) {
            return ((JCheckBox) o).isSelected();
        }

        if (o instanceof JComboBox) {
            return ((JComboBox) o).getSelectedItem();
        }
        return "";
    }

    public void setElementValue(E key, Object value) {
        JComponent o = getElement(key);

        String strValue = value == null ? "" : String.valueOf(value);
        if (o instanceof JPasswordField) {
            ((JPasswordField) o).setText(strValue);
        }
        if (o instanceof JTextField) {
            ((JTextField) o).setText(strValue);
        }
        if (o instanceof JRadioButton) {
            ((JRadioButton) o).setSelected(Boolean.valueOf(strValue.isEmpty() ? "false" : strValue));
        }
        if (o instanceof JCheckBox) {
            ((JCheckBox) o).setSelected(Boolean.valueOf(strValue.isEmpty() ? "false" : strValue));
        }
        if (o instanceof JComboBox) {
            ((JComboBox) o).setSelectedItem(value);
        }
    }

    public JLabel getElementLabel(E key) {
        return (JLabel) getObjectById(key.name() + "Label");
    }

    public void doCheck(E key) {
        getHandler().doCheck(key);
    }

}