/* 
* ##% Copyright (C) 2002, 2003, 2004, 2005, 2006, 2007, 2008 Code Lutin,
* Tony Chemit
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
* ##% */
package org.nuiton.jaxx.util;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import java.awt.event.ActionEvent;

/**
 * Ui helper class.
 *
 * @author tony
 */
public class UIHelper {

    public static ImageIcon createImageIcon(String path) {
        java.net.URL imgURL = UIHelper.class.getResource("/icons/" + path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            throw new IllegalArgumentException("could not find icon " + path);
        }
    }

    /**
     * Attach to <code>ui</code> an abort action,accessible by <code>ESC</code> key.
     *
     * @param ui ui
     */
    public static void setQuitAction(final JDialog ui) {
        JRootPane rootPane = ui.getRootPane();

        Action quitAction = new AbstractAction("quit") {
            private static final long serialVersionUID = -869095664995763057L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ui.dispose();
            }
        };
        rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        rootPane.getActionMap().put("quit", quitAction);
        ui.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
    }

    public static ImageIcon createActionIcon(String name) {
        return createImageIcon("action-" + name + ".png");
    }

}
