/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;

/**
 * DialogUI handler
 *
 * @param <M> type of model
 * @param <U> type of ui
 * @author chemit
 */
public abstract class DialogUIHandler<M extends DialogUIModel, U extends DialogUI<? extends DialogUIHandler<?,?>>> implements PropertyChangeListener {

    protected static Log log = LogFactory.getLog(DialogUIHandler.class);

    /** ui handled */
    private U ui;

    /** model handled */
    private M model;

    protected DialogUIHandler(U ui, M model) {
        this.ui = ui;
        this.model = model;
    }

    public U getUi() {
        return ui;
    }

    public M getModel() {
        return model;
    }

    public void init() {
        if (model == null) {
            throw new IllegalStateException("no model was defined for " + this);
        }
        model.addPropertyChangeListener(this);
    }

    public void dispose() {
        model.dispose();
        for (WindowListener windowListener : getUi().getWindowListeners()) {
            getUi().removeWindowListener(windowListener);
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        dispose();
    }
}