/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.util.Arrays;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OneClicListSelectionModel
implements ListSelectionModel {
    private static final Log log = LogFactory.getLog(OneClicListSelectionModel.class);
    protected final ListSelectionModel delegate;
    protected final ListModel model;
    private boolean[] _states;

    public static void installModel(JList list) {
        OneClicListSelectionModel newModel = new OneClicListSelectionModel(list);
        list.setSelectionModel(newModel);
    }

    public OneClicListSelectionModel(JList list) {
        this.delegate = list.getSelectionModel();
        this.model = list.getModel();
        this.delegate.clearSelection();
    }

    public OneClicListSelectionModel(ListSelectionModel delegate, ListModel model) {
        this.delegate = delegate;
        this.model = model;
        delegate.clearSelection();
    }

    protected boolean[] getStates(int selectedIndex) {
        int max = this.model.getSize();
        if (this._states == null || this._states.length != max) {
            this._states = new boolean[max];
        } else {
            Arrays.fill(this._states, false);
        }
        for (int i = 0; i < max; ++i) {
            this._states[i] = i != selectedIndex && this.delegate.isSelectedIndex(i);
        }
        return this._states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (index0 != index1) {
            this.delegate.setSelectionInterval(index0, index1);
            return;
        }
        this.delegate.setValueIsAdjusting(true);
        try {
            int max = this.model.getSize();
            if (log.isDebugEnabled()) {
                log.debug((Object)("single [index:" + index0 + "] [selected:" + this.isSelectedIndex(index0) + "] [size:" + max + "] [anchor:" + this.delegate.getAnchorSelectionIndex() + "] [lead:" + this.delegate.getLeadSelectionIndex() + "]"));
            }
            if (!this.isSelectedIndex(index0)) {
                this.delegate.addSelectionInterval(index0, index1);
                return;
            }
            if (max == index0) {
                this.delegate.removeIndexInterval(index0, index0);
                return;
            }
            boolean[] state = this.getStates(index0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("state : " + Arrays.toString(state)));
            }
            this.delegate.clearSelection();
            for (int i = 0; i < max; ++i) {
                if (!state[i]) continue;
                this.delegate.addSelectionInterval(i, i);
            }
        }
        finally {
            this.delegate.setValueIsAdjusting(false);
        }
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        this.delegate.addSelectionInterval(index0, index1);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        this.delegate.removeSelectionInterval(index0, index1);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.delegate.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.delegate.getMaxSelectionIndex();
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.delegate.isSelectedIndex(index);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.delegate.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.delegate.setAnchorSelectionIndex(index);
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.delegate.getLeadSelectionIndex();
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        this.delegate.setLeadSelectionIndex(index);
    }

    @Override
    public void clearSelection() {
        this.delegate.clearSelection();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.delegate.isSelectionEmpty();
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        this.delegate.insertIndexInterval(index, length, before);
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        this.delegate.removeIndexInterval(index0, index1);
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.delegate.setValueIsAdjusting(valueIsAdjusting);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.delegate.getValueIsAdjusting();
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.delegate.setSelectionMode(selectionMode);
    }

    @Override
    public int getSelectionMode() {
        return this.delegate.getSelectionMode();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener x) {
        this.delegate.addListSelectionListener(x);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener x) {
        this.delegate.removeListSelectionListener(x);
    }
}

