/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListModel;
import org.nuiton.jaxx.runtime.swing.Item;

public class JAXXComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;

    public JAXXComboBox() {
        this.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ListModel model = list.getModel();
                if (model instanceof JAXXComboBoxModel) {
                    String label;
                    List items = ((JAXXComboBoxModel)model).items;
                    Item item = null;
                    if (index == -1) {
                        for (Object item1 : items) {
                            Item testItem = (Item)item1;
                            if (testItem.getValue() != value) continue;
                            item = testItem;
                            break;
                        }
                    } else {
                        item = (Item)items.get(index);
                    }
                    if (item != null && (label = item.getLabel()) != null) {
                        value = label;
                    }
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.addItemListener(e -> {
            ComboBoxModel model = this.getModel();
            if (model instanceof JAXXComboBoxModel) {
                List items = ((JAXXComboBoxModel)model).items;
                for (int i = items.size() - 1; i >= 0; --i) {
                    Item item;
                    boolean selected = this.getSelectedIndex() == i;
                    if (selected == (item = (Item)items.get(i)).isSelected()) continue;
                    item.setSelected(selected);
                }
            }
        });
    }

    public void fillComboBox(Collection<?> data, Object select, String methodName) {
        Method m;
        try {
            m = select.getClass().getMethod(methodName, new Class[0]);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("could not find method " + methodName + " on " + select.getClass());
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object o : data) {
            boolean selected = o.equals(select);
            try {
                items.add(new Item(o.toString(), (String)m.invoke(o, new Object[0]), o, selected));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.setItems(items);
    }

    @Override
    protected void fireItemStateChanged(ItemEvent e) {
        super.fireItemStateChanged(e);
    }

    public void setItems(List<Item> items) {
        this.setModel(new JAXXComboBoxModel(items));
        ArrayList<Integer> selectedIndexList = new ArrayList<Integer>();
        for (int i = 0; i < items.size(); ++i) {
            if (!items.get(i).isSelected()) continue;
            selectedIndexList.add(i);
        }
        int[] selectedIndices = new int[selectedIndexList.size()];
        for (int i = 0; i < selectedIndexList.size(); ++i) {
            selectedIndices[i] = (Integer)selectedIndexList.get(i);
        }
        if (selectedIndices.length > 0) {
            this.setSelectedIndex(selectedIndices[0]);
        }
    }

    public List<Item> getItems() {
        if (this.getModel() instanceof JAXXComboBoxModel) {
            return ((JAXXComboBoxModel)this.getModel()).getItems();
        }
        return null;
    }

    public void setSelectedItem(Item item) {
        super.setSelectedItem(item == null ? null : item.getValue());
    }

    public Item getSelectedJaxxItem() {
        Object selected = super.getSelectedItem();
        return this.findItem(selected);
    }

    public Item findItem(Object value) {
        List<Item> items = this.getItems();
        if (items != null) {
            for (Item i : items) {
                if (!i.getValue().equals(value)) continue;
                return i;
            }
        }
        return null;
    }

    public void addItem(Item item) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.add(item);
            this.setItems(items);
        }
    }

    public void addAllItems(Collection<Item> itemsToAdd) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.addAll(itemsToAdd);
            this.setItems(items);
        }
    }

    public void removeItem(Item item) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.remove(item);
            this.setItems(items);
        }
    }

    public void removeAllItems(Collection<Item> itemsToRemove) {
        List<Item> items = this.getItems();
        if (items != null) {
            items.removeAll(itemsToRemove);
            this.setItems(items);
        }
    }

    public class JAXXComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<Item> items;
        private Object selectedItem;
        private static final long serialVersionUID = -8940733376638766414L;

        public JAXXComboBoxModel(List<Item> items) {
            this.items = items;
            PropertyChangeListener listener = e -> {
                if (e.getPropertyName().equals("selected")) {
                    int[] newSelection;
                    Item item = (Item)e.getSource();
                    int itemIndex = this.items.indexOf(item);
                    int[] oldSelection = new int[]{JAXXComboBox.this.getSelectedIndex()};
                    int index = -1;
                    for (int i = 0; i < oldSelection.length; ++i) {
                        if (oldSelection[i] != itemIndex) continue;
                        index = i;
                        break;
                    }
                    if (item.isSelected()) {
                        if (index != -1) {
                            return;
                        }
                        newSelection = new int[oldSelection.length + 1];
                        System.arraycopy(oldSelection, 0, newSelection, 0, oldSelection.length);
                        newSelection[newSelection.length - 1] = itemIndex;
                    } else {
                        if (index == -1) {
                            return;
                        }
                        newSelection = new int[oldSelection.length - 1];
                        System.arraycopy(oldSelection, 0, newSelection, 0, index);
                        System.arraycopy(oldSelection, index + 1, newSelection, index, oldSelection.length - 1 - index);
                    }
                    if (newSelection.length > 0) {
                        JAXXComboBox.this.setSelectedIndex(newSelection[0]);
                    }
                } else {
                    for (int i = 0; i < this.getSize(); ++i) {
                        if (this.getElementAt(i) != ((Item)e.getSource()).getValue()) continue;
                        this.fireContentsChanged(this, i, i);
                        if (JAXXComboBox.this.getSelectedIndex() == i) {
                            JAXXComboBox.this.fireItemStateChanged(new ItemEvent(JAXXComboBox.this, 701, this.getElementAt(i), 2));
                        }
                        return;
                    }
                }
            };
            for (Item item : items) {
                item.addPropertyChangeListener(listener);
            }
        }

        public List<Item> getItems() {
            return this.items;
        }

        @Override
        public Object getElementAt(int i) {
            return this.items.get(i).getValue();
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object selectedItem) {
            if (this.selectedItem != null && !this.selectedItem.equals(selectedItem) || this.selectedItem == null && selectedItem != null) {
                this.selectedItem = selectedItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }
}

